/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.dto.BrokerRejection;
import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskAssignmentRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskCompletionRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskUpdateRequest;
import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.ZeebeRestController;
import io.camunda.zeebe.protocol.record.RejectionType;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.server.ServerWebExchange;

@ZeebeRestController
public class UserTaskController {
    private final BrokerClient brokerClient;

    @Autowired
    public UserTaskController(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }

    @PostMapping(path={"/user-tasks/{userTaskKey}/completion"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> completeUserTask(ServerWebExchange context, @PathVariable long userTaskKey, @RequestBody(required=false) UserTaskCompletionRequest completionRequest) {
        return (CompletableFuture)RequestMapper.toUserTaskCompletionRequest(completionRequest, userTaskKey, context).fold(UserTaskController::handleRequestMappingError, this::sendBrokerRequest);
    }

    @PostMapping(path={"/user-tasks/{userTaskKey}/assignment"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> assignUserTask(ServerWebExchange context, @PathVariable long userTaskKey, @RequestBody UserTaskAssignmentRequest assignmentRequest) {
        return (CompletableFuture)RequestMapper.toUserTaskAssignmentRequest(assignmentRequest, userTaskKey, context).fold(UserTaskController::handleRequestMappingError, this::sendBrokerRequest);
    }

    @DeleteMapping(path={"/user-tasks/{userTaskKey}/assignee"})
    public CompletableFuture<ResponseEntity<Object>> unassignUserTask(ServerWebExchange context, @PathVariable long userTaskKey) {
        return (CompletableFuture)RequestMapper.toUserTaskUnassignmentRequest(userTaskKey, context).fold(UserTaskController::handleRequestMappingError, this::sendBrokerRequest);
    }

    @PatchMapping(path={"/user-tasks/{userTaskKey}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"})
    public CompletableFuture<ResponseEntity<Object>> updateUserTask(ServerWebExchange context, @PathVariable long userTaskKey, @RequestBody(required=false) UserTaskUpdateRequest updateRequest) {
        return (CompletableFuture)RequestMapper.toUserTaskUpdateRequest(updateRequest, userTaskKey, context).fold(UserTaskController::handleRequestMappingError, this::sendBrokerRequest);
    }

    private CompletableFuture<ResponseEntity<Object>> sendBrokerRequest(BrokerRequest<?> brokerRequest) {
        return this.brokerClient.sendRequest(brokerRequest).handleAsync((response, error) -> RestErrorMapper.getResponse(response, error, UserTaskController::mapRejectionToProblem).orElseGet(() -> ResponseEntity.noContent().build()));
    }

    private static CompletableFuture<ResponseEntity<Object>> handleRequestMappingError(ProblemDetail problemDetail) {
        return CompletableFuture.completedFuture(RestErrorMapper.mapProblemToResponse(problemDetail));
    }

    private static ProblemDetail mapRejectionToProblem(BrokerRejection rejection) {
        String message = String.format("Command '%s' rejected with code '%s': %s", rejection.intent(), rejection.type(), rejection.reason());
        String title = rejection.type().name();
        return switch (rejection.type()) {
            case RejectionType.NOT_FOUND -> RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.NOT_FOUND, message, title);
            case RejectionType.INVALID_STATE -> RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.CONFLICT, message, title);
            case RejectionType.INVALID_ARGUMENT, RejectionType.ALREADY_EXISTS -> RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, message, title);
            default -> RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, message, title);
        };
    }
}

