/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.gateway.impl.broker.request.BrokerExecuteCommand;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import org.agrona.DirectBuffer;

public final class BrokerSetVariablesRequest
extends BrokerExecuteCommand<VariableDocumentRecord> {
    private final VariableDocumentRecord requestDto = new VariableDocumentRecord();

    public BrokerSetVariablesRequest() {
        super(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE);
    }

    public BrokerSetVariablesRequest setElementInstanceKey(long elementInstanceKey) {
        this.request.setPartitionId(Protocol.decodePartitionId((long)elementInstanceKey));
        this.requestDto.setScopeKey(elementInstanceKey);
        return this;
    }

    public BrokerSetVariablesRequest setVariables(DirectBuffer variables) {
        this.requestDto.setVariables(variables);
        return this;
    }

    public BrokerSetVariablesRequest setLocal(boolean local) {
        VariableDocumentUpdateSemantic updateSemantics = local ? VariableDocumentUpdateSemantic.LOCAL : VariableDocumentUpdateSemantic.PROPAGATE;
        this.requestDto.setUpdateSemantics(updateSemantics);
        return this;
    }

    public VariableDocumentRecord getRequestWriter() {
        return this.requestDto;
    }

    @Override
    protected VariableDocumentRecord toResponseDto(DirectBuffer buffer) {
        VariableDocumentRecord responseDto = new VariableDocumentRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }
}

