/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import io.atomix.cluster.messaging.MessagingConfig;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.configuration.ConfigurationDefaults;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import io.camunda.zeebe.gateway.impl.configuration.SecurityCfg;
import io.camunda.zeebe.util.StringUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ClusterCfg {
    private List<String> initialContactPoints = Collections.singletonList("127.0.0.1:26502");
    private Duration requestTimeout = ConfigurationDefaults.DEFAULT_REQUEST_TIMEOUT;
    private String clusterName = "zeebe-cluster";
    private String memberId = "gateway";
    private String host = "0.0.0.0";
    private String advertisedHost = null;
    private int port = 26502;
    private Integer advertisedPort = null;
    private MembershipCfg membership = new MembershipCfg();
    private SecurityCfg security = new SecurityCfg();
    private MessagingConfig.CompressionAlgorithm messageCompression = MessagingConfig.CompressionAlgorithm.NONE;

    public String getMemberId() {
        return this.memberId;
    }

    public ClusterCfg setMemberId(String memberId) {
        this.memberId = memberId;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ClusterCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public String getAdvertisedHost() {
        return Optional.ofNullable(this.advertisedHost).orElseGet(this::getHost);
    }

    public ClusterCfg setAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ClusterCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public int getAdvertisedPort() {
        return Optional.ofNullable(this.advertisedPort).orElseGet(this::getPort);
    }

    public ClusterCfg setAdvertisedPort(int advertisedPort) {
        this.advertisedPort = advertisedPort;
        return this;
    }

    @Deprecated(since="8.1.0", forRemoval=true)
    public ClusterCfg setContactPoint(String contactPoint) {
        Loggers.GATEWAY_CFG_LOGGER.warn("Configuring deprecated property 'contactPoint', will use 'initialContactPoints'. Please consider to migrate to 'initialContactPoints' property, which allows to set a list of contact points.");
        this.setInitialContactPoints(Collections.singletonList(contactPoint));
        return this;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public ClusterCfg setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterCfg setClusterName(String name) {
        this.clusterName = name;
        return this;
    }

    public MembershipCfg getMembership() {
        return this.membership;
    }

    public void setMembership(MembershipCfg membership) {
        this.membership = membership;
    }

    public SecurityCfg getSecurity() {
        return this.security;
    }

    public ClusterCfg setSecurity(SecurityCfg security) {
        this.security = security;
        return this;
    }

    public MessagingConfig.CompressionAlgorithm getMessageCompression() {
        return this.messageCompression;
    }

    public void setMessageCompression(MessagingConfig.CompressionAlgorithm compressionAlgorithm) {
        this.messageCompression = compressionAlgorithm;
    }

    public List<String> getInitialContactPoints() {
        return this.initialContactPoints;
    }

    public ClusterCfg setInitialContactPoints(List<String> initialContactPoints) {
        this.initialContactPoints = (List)StringUtil.LIST_SANITIZER.apply(initialContactPoints);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.initialContactPoints, this.requestTimeout, this.clusterName, this.memberId, this.host, this.port, this.membership, this.security, this.messageCompression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterCfg that = (ClusterCfg)o;
        return this.port == that.port && Objects.equals(this.initialContactPoints, that.initialContactPoints) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.host, that.host) && Objects.equals(this.membership, that.membership) && Objects.equals(this.security, that.security) && Objects.equals(this.messageCompression, that.messageCompression);
    }

    public String toString() {
        return "ClusterCfg{initialContactPoints=" + this.initialContactPoints + ", requestTimeout=" + this.requestTimeout + ", clusterName='" + this.clusterName + "', memberId='" + this.memberId + "', host='" + this.host + "', port=" + this.port + ", membership=" + this.membership + ", security=" + this.security + ", messageCompression=" + this.messageCompression + "}";
    }
}

