/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.interceptors.impl;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.exception.TokenVerificationException;
import io.camunda.identity.sdk.tenants.dto.Tenant;
import io.camunda.zeebe.gateway.impl.configuration.IdentityCfg;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdentityInterceptor
implements ServerInterceptor {
    public static final Context.Key<List<String>> AUTHORIZED_TENANTS_KEY = Context.key((String)"io.camunda.zeebe:authorized_tenants");
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityInterceptor.class);
    private static final Metadata.Key<String> AUTH_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Identity identity;
    private final MultiTenancyCfg multiTenancy;

    public IdentityInterceptor(IdentityCfg config, MultiTenancyCfg multiTenancy) {
        this(IdentityInterceptor.createIdentity(config), multiTenancy);
    }

    public IdentityInterceptor(Identity identity, MultiTenancyCfg multiTenancy) {
        this.identity = identity;
        this.multiTenancy = multiTenancy;
    }

    private static Identity createIdentity(IdentityCfg config) {
        return new Identity(new IdentityConfiguration.Builder().withIssuerBackendUrl(config.getIssuerBackendUrl()).withAudience(config.getAudience()).withType(config.getType().name()).withBaseUrl(config.getBaseUrl()).build());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MethodDescriptor methodDescriptor = call.getMethodDescriptor();
        String authorization = (String)headers.get(AUTH_KEY);
        if (authorization == null) {
            LOGGER.debug("Denying call {} as no token was provided", (Object)methodDescriptor.getFullMethodName());
            return this.deny(call, Status.UNAUTHENTICATED.augmentDescription("Expected bearer token at header with key [%s], but found nothing".formatted(AUTH_KEY.name())));
        }
        String token = authorization.replaceFirst("^Bearer ", "");
        try {
            this.identity.authentication().verifyToken(token);
        }
        catch (TokenVerificationException e) {
            LOGGER.debug("Denying call {} as the token could not be fully verified. Error message: {}", (Object)methodDescriptor.getFullMethodName(), (Object)e.getMessage());
            return this.deny(call, Status.UNAUTHENTICATED.augmentDescription("Failed to parse bearer token, see cause for details").withCause((Throwable)e));
        }
        if (!this.multiTenancy.isEnabled()) {
            return next.startCall(call, headers);
        }
        try {
            List<String> authorizedTenants = this.identity.tenants().forToken(token).stream().map(Tenant::getTenantId).toList();
            Context context = Context.current().withValue(AUTHORIZED_TENANTS_KEY, authorizedTenants);
            return Contexts.interceptCall((Context)context, call, (Metadata)headers, next);
        }
        catch (RuntimeException e) {
            LOGGER.debug("Denying call {} as the authorized tenants could not be retrieved from Identity. Error message: {}", (Object)methodDescriptor.getFullMethodName(), (Object)e.getMessage());
            return this.deny(call, Status.UNAUTHENTICATED.augmentDescription("Expected Identity to provide authorized tenants, see cause for details").withCause((Throwable)e));
        }
    }

    private <ReqT> ServerCall.Listener<ReqT> deny(ServerCall<ReqT, ?> call, Status status) {
        call.close(status, new Metadata());
        return new ServerCall.Listener<ReqT>(){};
    }
}

