/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import com.fasterxml.jackson.core.JsonParseException;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class RequestUtil {
    public static DirectBuffer ensureJsonSet(String value) {
        if (value == null || value.trim().isEmpty()) {
            return DocumentValue.EMPTY_DOCUMENT;
        }
        try {
            return new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)value));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JsonParseException) {
                JsonParseException parseException = (JsonParseException)cause;
                JsonParseException descriptiveException = new JsonParseException(parseException.getProcessor(), "Invalid JSON value: " + value, parseException.getLocation(), cause);
                LangUtil.rethrowUnchecked((Throwable)descriptiveException);
                return DocumentValue.EMPTY_DOCUMENT;
            }
            if (cause instanceof IllegalArgumentException) {
                LangUtil.rethrowUnchecked((Throwable)cause);
                return DocumentValue.EMPTY_DOCUMENT;
            }
            throw e;
        }
    }
}

