/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.RequestDispatchStrategy;
import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.gateway.impl.broker.PublishMessageDispatchStrategy;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class BrokerPublishMessageRequest
extends BrokerExecuteCommand<MessageRecord> {
    private final MessageRecord requestDto = new MessageRecord();
    private final PublishMessageDispatchStrategy dispatchStrategy;

    public BrokerPublishMessageRequest(String messageName, String correlationKey) {
        super(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH);
        this.requestDto.setName(messageName).setCorrelationKey(correlationKey);
        this.dispatchStrategy = new PublishMessageDispatchStrategy(correlationKey);
    }

    public DirectBuffer getCorrelationKey() {
        return this.requestDto.getCorrelationKeyBuffer();
    }

    public BrokerPublishMessageRequest setMessageId(String messageId) {
        this.requestDto.setMessageId(messageId);
        return this;
    }

    public BrokerPublishMessageRequest setTimeToLive(long timeToLive) {
        this.requestDto.setTimeToLive(timeToLive);
        return this;
    }

    public BrokerPublishMessageRequest setVariables(DirectBuffer variables) {
        this.requestDto.setVariables(variables);
        return this;
    }

    public BrokerPublishMessageRequest setTenantId(String tenantId) {
        this.requestDto.setTenantId(tenantId);
        return this;
    }

    public MessageRecord getRequestWriter() {
        return this.requestDto;
    }

    protected MessageRecord toResponseDto(DirectBuffer buffer) {
        MessageRecord responseDto = new MessageRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }

    public Optional<RequestDispatchStrategy> requestDispatchStrategy() {
        return Optional.of(this.dispatchStrategy);
    }
}

