/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.FrameUtil;
import io.camunda.zeebe.journal.file.IndexInfo;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalSegment;
import io.camunda.zeebe.journal.file.record.JournalRecordReaderUtil;
import io.camunda.zeebe.journal.file.record.SBESerializer;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;

class MappedJournalSegmentReader {
    private final ByteBuffer buffer;
    private final JournalIndex index;
    private final JournalSegment segment;
    private long currentIndex;
    private final JournalRecordReaderUtil recordReader;
    private final int descriptorLength;

    MappedJournalSegmentReader(ByteBuffer buffer, JournalSegment segment, JournalIndex index) {
        this.index = index;
        this.segment = segment;
        this.descriptorLength = segment.descriptor().length();
        this.recordReader = new JournalRecordReaderUtil(new SBESerializer());
        this.buffer = buffer;
        this.reset();
    }

    public boolean hasNext() {
        if (!this.segment.isOpen()) {
            return false;
        }
        return FrameUtil.hasValidVersion(this.buffer);
    }

    public JournalRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        FrameUtil.readVersion(this.buffer);
        JournalRecord currentEntry = this.recordReader.read(this.buffer, this.getNextIndex());
        this.currentIndex = currentEntry.index();
        return currentEntry;
    }

    public void reset() {
        this.buffer.position(this.descriptorLength);
        this.currentIndex = this.segment.index() - 1L;
    }

    public void seek(long index) {
        this.checkSegmentOpen();
        long firstIndex = this.segment.index();
        long lastIndex = this.segment.lastIndex();
        this.reset();
        IndexInfo position = this.index.lookup(index - 1L);
        if (position != null && position.index() >= firstIndex && position.index() <= lastIndex) {
            this.buffer.position(position.position());
            this.currentIndex = position.index() - 1L;
        }
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
    }

    public void close() {
        this.segment.onReaderClosed(this);
    }

    long getNextIndex() {
        return this.currentIndex + 1L;
    }

    private void checkSegmentOpen() {
        Preconditions.checkState((boolean)this.segment.isOpen(), (Object)"Segment is already closed. Reader must reset to a valid index.");
    }
}

