/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.JournalSegment;
import io.camunda.zeebe.journal.file.MappedJournalSegmentWriter;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import java.nio.BufferOverflowException;
import org.agrona.DirectBuffer;

class SegmentedJournalWriter {
    private final SegmentedJournal journal;
    private final JournalMetrics journalMetrics;
    private JournalSegment currentSegment;
    private MappedJournalSegmentWriter currentWriter;

    public SegmentedJournalWriter(SegmentedJournal journal) {
        this.journal = journal;
        this.journalMetrics = journal.getJournalMetrics();
        this.currentSegment = journal.getLastSegment();
        this.currentWriter = this.currentSegment.writer();
    }

    public long getLastIndex() {
        return this.currentWriter.getLastIndex();
    }

    public JournalRecord getLastEntry() {
        return this.currentWriter.getLastEntry();
    }

    public long getNextIndex() {
        return this.currentWriter.getNextIndex();
    }

    public JournalRecord append(long asqn, DirectBuffer data) {
        try {
            return this.currentWriter.append(asqn, data);
        }
        catch (BufferOverflowException e) {
            if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
                throw e;
            }
            this.journalMetrics.observeSegmentCreation(this::createNewSegment);
            return this.currentWriter.append(asqn, data);
        }
    }

    public void append(JournalRecord record) {
        try {
            this.currentWriter.append(record);
        }
        catch (BufferOverflowException e) {
            if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
                throw e;
            }
            this.journalMetrics.observeSegmentCreation(this::createNewSegment);
            this.currentWriter.append(record);
        }
    }

    public void reset(long index) {
        this.currentSegment = this.journal.resetSegments(index);
        this.currentWriter = this.currentSegment.writer();
    }

    public void deleteAfter(long index) {
        while (index < this.currentSegment.index() && this.currentSegment != this.journal.getFirstSegment()) {
            this.journal.removeSegment(this.currentSegment);
            this.currentSegment = this.journal.getLastSegment();
            this.currentWriter = this.currentSegment.writer();
        }
        this.currentWriter.truncate(index);
    }

    public void flush() {
        this.journalMetrics.observeSegmentFlush(this.currentWriter::flush);
    }

    public void close() {
        this.currentWriter.close();
    }

    private void createNewSegment() {
        this.currentWriter.flush();
        this.currentSegment = this.journal.getNextSegment();
        this.currentWriter = this.currentSegment.writer();
    }
}

