/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.CorruptedJournalException;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.FrameUtil;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.record.JournalRecordReaderUtil;
import io.camunda.zeebe.journal.record.JournalRecordSerializer;
import io.camunda.zeebe.journal.record.PersistedJournalRecord;
import io.camunda.zeebe.journal.record.RecordData;
import io.camunda.zeebe.journal.record.RecordMetadata;
import io.camunda.zeebe.journal.record.SBESerializer;
import io.camunda.zeebe.journal.util.ChecksumGenerator;
import io.camunda.zeebe.util.Either;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class SegmentWriter {
    private final MappedByteBuffer buffer;
    private final Segment segment;
    private final JournalIndex index;
    private final long firstIndex;
    private JournalRecord lastEntry;
    private boolean isOpen = true;
    private final JournalRecordReaderUtil recordUtil;
    private final ChecksumGenerator checksumGenerator = new ChecksumGenerator();
    private final JournalRecordSerializer serializer = new SBESerializer();
    private final MutableDirectBuffer writeBuffer = new UnsafeBuffer();
    private final int descriptorLength;

    SegmentWriter(MappedByteBuffer buffer, Segment segment, JournalIndex index, long lastWrittenIndex) {
        this.segment = segment;
        this.descriptorLength = segment.descriptor().length();
        this.recordUtil = new JournalRecordReaderUtil(this.serializer);
        this.index = index;
        this.firstIndex = segment.index();
        this.buffer = buffer;
        this.writeBuffer.wrap((ByteBuffer)buffer);
        this.reset(0L, lastWrittenIndex);
    }

    long getLastIndex() {
        return this.lastEntry != null ? this.lastEntry.index() : this.segment.index() - 1L;
    }

    JournalRecord getLastEntry() {
        return this.lastEntry;
    }

    long getNextIndex() {
        if (this.lastEntry != null) {
            return this.lastEntry.index() + 1L;
        }
        return this.firstIndex;
    }

    Either<JournalException.SegmentFull, JournalRecord> append(long asqn, DirectBuffer data) {
        RecordData indexedRecord;
        int metadataLength;
        int frameLength;
        long recordIndex = this.getNextIndex();
        int startPosition = this.buffer.position();
        Either<JournalException.SegmentFull, Integer> writeResult = this.writeRecord(startPosition + (frameLength = FrameUtil.getLength()) + (metadataLength = this.serializer.getMetadataLength()), indexedRecord = new RecordData(recordIndex, asqn, data));
        if (writeResult.isLeft()) {
            this.buffer.position(startPosition);
            return Either.left((Object)((JournalException.SegmentFull)writeResult.getLeft()));
        }
        int recordLength = (Integer)writeResult.get();
        long checksum = this.checksumGenerator.compute(this.buffer, startPosition + frameLength + metadataLength, recordLength);
        this.writeMetadata(startPosition, frameLength, recordLength, checksum);
        this.updateLastWrittenEntry(startPosition, frameLength, metadataLength);
        FrameUtil.writeVersion(this.buffer, startPosition);
        this.buffer.position(startPosition + frameLength + metadataLength + recordLength);
        return Either.right((Object)this.lastEntry);
    }

    Either<JournalException.SegmentFull, Void> append(JournalRecord record) {
        RecordData indexedRecord;
        int metadataLength;
        int frameLength;
        long nextIndex = this.getNextIndex();
        if (record.index() != nextIndex) {
            throw new JournalException.InvalidIndex(String.format("The record index is not sequential. Expected the next index to be %d, but the record to append has index %d", nextIndex, record.index()));
        }
        int startPosition = this.buffer.position();
        Either<JournalException.SegmentFull, Integer> writeResult = this.writeRecord(startPosition + (frameLength = FrameUtil.getLength()) + (metadataLength = this.serializer.getMetadataLength()), indexedRecord = new RecordData(record.index(), record.asqn(), record.data()));
        if (writeResult.isLeft()) {
            this.buffer.position(startPosition);
            return Either.left((Object)((JournalException.SegmentFull)writeResult.getLeft()));
        }
        int recordLength = (Integer)writeResult.get();
        long checksum = this.checksumGenerator.compute(this.buffer, startPosition + frameLength + metadataLength, recordLength);
        if (record.checksum() != checksum) {
            this.buffer.position(startPosition);
            throw new JournalException.InvalidChecksum(String.format("Failed to append record %s. Checksum does not match", record));
        }
        this.writeMetadata(startPosition, frameLength, recordLength, checksum);
        this.updateLastWrittenEntry(startPosition, frameLength, metadataLength);
        FrameUtil.writeVersion(this.buffer, startPosition);
        this.buffer.position(startPosition + frameLength + metadataLength + recordLength);
        return Either.right(null);
    }

    private void updateLastWrittenEntry(int startPosition, int frameLength, int metadataLength) {
        RecordMetadata metadata = this.serializer.readMetadata((DirectBuffer)this.writeBuffer, startPosition + frameLength);
        RecordData data = this.serializer.readData((DirectBuffer)this.writeBuffer, startPosition + frameLength + metadataLength);
        this.lastEntry = new PersistedJournalRecord(metadata, data);
        this.index.index(this.lastEntry, startPosition);
    }

    private void writeMetadata(int startPosition, int frameLength, int recordLength, long checksum) {
        RecordMetadata recordMetadata = new RecordMetadata(checksum, recordLength);
        this.serializer.writeMetadata(recordMetadata, this.writeBuffer, startPosition + frameLength);
    }

    private Either<JournalException.SegmentFull, Integer> writeRecord(int offset, RecordData indexedRecord) {
        Either<BufferOverflowException, Integer> recordLength = this.serializer.writeData(indexedRecord, this.writeBuffer, offset);
        if (recordLength.isLeft()) {
            return Either.left((Object)new JournalException.SegmentFull("Not enough space to write record"));
        }
        int nextEntryOffset = offset + (Integer)recordLength.get();
        this.invalidateNextEntry(nextEntryOffset);
        return Either.right((Object)((Integer)recordLength.get()));
    }

    private void invalidateNextEntry(int position) {
        if (position >= this.buffer.capacity()) {
            return;
        }
        FrameUtil.markAsIgnored(this.buffer, position);
    }

    private void reset(long index) {
        this.reset(index, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(long index, long lastWrittenIndex) {
        long nextIndex;
        this.buffer.position(this.descriptorLength);
        this.buffer.mark();
        int position = this.buffer.position();
        try {
            for (nextIndex = this.firstIndex; (index == 0L || nextIndex <= index) && FrameUtil.hasValidVersion(this.buffer); ++nextIndex) {
                FrameUtil.readVersion(this.buffer);
                this.lastEntry = this.recordUtil.read(this.buffer, nextIndex);
                this.index.index(this.lastEntry, position);
                this.buffer.mark();
                position = this.buffer.position();
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (CorruptedJournalException e) {
            this.handleChecksumMismatch(e, nextIndex, lastWrittenIndex, position);
        }
        finally {
            this.buffer.reset();
        }
    }

    private void handleChecksumMismatch(CorruptedJournalException e, long nextIndex, long lastWrittenIndex, int position) {
        if (nextIndex > lastWrittenIndex) {
            FrameUtil.markAsIgnored(this.buffer, position);
            this.buffer.position(position);
            this.buffer.mark();
            return;
        }
        throw e;
    }

    public void truncate(long index) {
        if (index >= this.getLastIndex()) {
            return;
        }
        this.lastEntry = null;
        this.index.deleteAfter(index);
        if (index < this.segment.index()) {
            this.buffer.position(this.descriptorLength);
            this.invalidateNextEntry(this.descriptorLength);
        } else {
            this.reset(index);
            this.invalidateNextEntry(this.buffer.position());
        }
    }

    void flush() {
        this.buffer.force();
    }

    void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.flush();
        }
    }
}

