/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.file.SegmentWriter;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import io.camunda.zeebe.util.Either;
import org.agrona.DirectBuffer;

class SegmentedJournalWriter {
    private final SegmentedJournal journal;
    private final JournalMetrics journalMetrics;
    private Segment currentSegment;
    private SegmentWriter currentWriter;

    public SegmentedJournalWriter(SegmentedJournal journal) {
        this.journal = journal;
        this.journalMetrics = journal.getJournalMetrics();
        this.currentSegment = journal.getLastSegment();
        this.currentWriter = this.currentSegment.writer();
    }

    public long getLastIndex() {
        return this.currentWriter.getLastIndex();
    }

    public JournalRecord getLastEntry() {
        return this.currentWriter.getLastEntry();
    }

    public long getNextIndex() {
        return this.currentWriter.getNextIndex();
    }

    public JournalRecord append(long asqn, DirectBuffer data) {
        Either<JournalException.SegmentFull, JournalRecord> appendResult = this.currentWriter.append(asqn, data);
        if (appendResult.isRight()) {
            return (JournalRecord)appendResult.get();
        }
        if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
            throw new JournalException.SegmentSizeTooSmall("Failed appending, segment size is too small");
        }
        this.journalMetrics.observeSegmentCreation(this::createNewSegment);
        Either<JournalException.SegmentFull, JournalRecord> appendResultOnNewSegment = this.currentWriter.append(asqn, data);
        if (appendResultOnNewSegment.isLeft()) {
            throw (JournalException.SegmentFull)appendResultOnNewSegment.getLeft();
        }
        return (JournalRecord)appendResultOnNewSegment.get();
    }

    public void append(JournalRecord record) {
        Either<JournalException.SegmentFull, Void> appendResult = this.currentWriter.append(record);
        if (appendResult.isRight()) {
            return;
        }
        if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
            throw new JournalException.SegmentSizeTooSmall("Failed appending, segment size is too small");
        }
        this.journalMetrics.observeSegmentCreation(this::createNewSegment);
        Either<JournalException.SegmentFull, Void> resultInNewSegment = this.currentWriter.append(record);
        if (resultInNewSegment.isLeft()) {
            throw (JournalException.SegmentFull)resultInNewSegment.getLeft();
        }
    }

    public void reset(long index) {
        this.currentSegment = this.journal.resetSegments(index);
        this.currentWriter = this.currentSegment.writer();
    }

    public void deleteAfter(long index) {
        while (index < this.currentSegment.index() && this.currentSegment != this.journal.getFirstSegment()) {
            this.journal.removeSegment(this.currentSegment);
            this.currentSegment = this.journal.getLastSegment();
            this.currentWriter = this.currentSegment.writer();
        }
        this.currentWriter.truncate(index);
    }

    public void flush() {
        this.journalMetrics.observeSegmentFlush(this.currentWriter::flush);
    }

    public void close() {
        this.currentWriter.close();
    }

    private void createNewSegment() {
        this.currentWriter.flush();
        this.currentSegment = this.journal.getNextSegment();
        this.currentWriter = this.currentSegment.writer();
    }
}

