/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.record;

import io.camunda.zeebe.journal.CorruptedJournalException;
import io.camunda.zeebe.journal.file.MessageHeaderDecoder;
import io.camunda.zeebe.journal.file.MessageHeaderEncoder;
import io.camunda.zeebe.journal.file.RecordDataDecoder;
import io.camunda.zeebe.journal.file.RecordDataEncoder;
import io.camunda.zeebe.journal.file.RecordMetadataDecoder;
import io.camunda.zeebe.journal.file.RecordMetadataEncoder;
import io.camunda.zeebe.journal.record.JournalRecordSerializer;
import io.camunda.zeebe.journal.record.RecordData;
import io.camunda.zeebe.journal.record.RecordMetadata;
import io.camunda.zeebe.util.Either;
import java.nio.BufferOverflowException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class SBESerializer
implements JournalRecordSerializer {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final RecordMetadataEncoder metadataEncoder = new RecordMetadataEncoder();
    private final RecordDataEncoder recordEncoder = new RecordDataEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final RecordMetadataDecoder metadataDecoder = new RecordMetadataDecoder();
    private final RecordDataDecoder recordDecoder = new RecordDataDecoder();

    @Override
    public Either<BufferOverflowException, Integer> writeData(RecordData record, MutableDirectBuffer buffer, int offset) {
        if (offset + this.getSerializedLength(record) > buffer.capacity()) {
            return Either.left((Object)new BufferOverflowException());
        }
        this.headerEncoder.wrap(buffer, offset).blockLength(this.recordEncoder.sbeBlockLength()).templateId(this.recordEncoder.sbeTemplateId()).schemaId(this.recordEncoder.sbeSchemaId()).version(this.recordEncoder.sbeSchemaVersion());
        this.recordEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.recordEncoder.index(record.index()).asqn(record.asqn()).putData(record.data(), 0, record.data().capacity());
        int writtenBytes = this.headerEncoder.encodedLength() + this.recordEncoder.encodedLength();
        return Either.right((Object)writtenBytes);
    }

    @Override
    public int writeMetadata(RecordMetadata metadata, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.metadataEncoder.sbeBlockLength()).templateId(this.metadataEncoder.sbeTemplateId()).schemaId(this.metadataEncoder.sbeSchemaId()).version(this.metadataEncoder.sbeSchemaVersion());
        this.metadataEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.metadataEncoder.checksum(metadata.checksum()).length(metadata.length());
        return this.headerEncoder.encodedLength() + this.metadataEncoder.encodedLength();
    }

    @Override
    public int getMetadataLength() {
        return this.headerEncoder.encodedLength() + this.metadataEncoder.sbeBlockLength();
    }

    @Override
    public RecordMetadata readMetadata(DirectBuffer buffer, int offset) {
        if (!this.hasMetadata(buffer, offset)) {
            throw new CorruptedJournalException("Cannot read metadata. Header does not match.");
        }
        this.metadataDecoder.wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        return new RecordMetadata(this.metadataDecoder.checksum(), this.metadataDecoder.length());
    }

    @Override
    public RecordData readData(DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        if (this.headerDecoder.schemaId() != this.recordDecoder.sbeSchemaId() || this.headerDecoder.templateId() != this.recordDecoder.sbeTemplateId()) {
            throw new CorruptedJournalException("Cannot read record. Header does not match.");
        }
        this.recordDecoder.wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        UnsafeBuffer data = new UnsafeBuffer();
        this.recordDecoder.wrapData((DirectBuffer)data);
        return new RecordData(this.recordDecoder.index(), this.recordDecoder.asqn(), (DirectBuffer)data);
    }

    @Override
    public int getMetadataLength(DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        return this.headerDecoder.encodedLength() + this.headerDecoder.blockLength();
    }

    private boolean hasMetadata(DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        return this.headerDecoder.schemaId() == this.metadataDecoder.sbeSchemaId() && this.headerDecoder.templateId() == this.metadataDecoder.sbeTemplateId();
    }

    private int getSerializedLength(RecordData record) {
        return this.headerEncoder.encodedLength() + this.recordEncoder.sbeBlockLength() + RecordDataEncoder.dataHeaderLength() + record.data().capacity();
    }
}

