/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.file.JournalMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;

final class JournalMetrics {
    private final Timer segmentCreationTime;
    private final Timer segmentTruncateTime;
    private final Timer segmentFlushTime;
    private final Timer journalFlushTime;
    private final AtomicLong segmentCount;
    private final AtomicLong journalOpenDuration;
    private final Timer segmentAllocationTime;
    private final Timer appendLatency;
    private final Counter appendRate;
    private final Counter appendDataRate;
    private final Timer seekLatency;
    private final MeterRegistry registry;

    JournalMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.segmentCreationTime = this.makeTimer(JournalMetricsDoc.SEGMENT_CREATION_TIME);
        this.segmentTruncateTime = this.makeTimer(JournalMetricsDoc.SEGMENT_TRUNCATE_TIME);
        this.segmentFlushTime = this.makeTimer(JournalMetricsDoc.SEGMENT_FLUSH_TIME);
        this.journalFlushTime = this.makeTimer(JournalMetricsDoc.JOURNAL_FLUSH_TIME);
        this.segmentCount = new AtomicLong(0L);
        Gauge.builder((String)JournalMetricsDoc.SEGMENT_COUNT.getName(), this.segmentCount::get).description(JournalMetricsDoc.SEGMENT_COUNT.getDescription()).register(registry);
        this.journalOpenDuration = new AtomicLong(0L);
        Gauge.builder((String)JournalMetricsDoc.JOURNAL_OPERATION_DURATION.getName(), this.journalOpenDuration::get).description(JournalMetricsDoc.JOURNAL_OPERATION_DURATION.getDescription()).register(registry);
        this.segmentAllocationTime = this.makeTimer(JournalMetricsDoc.SEGMENT_ALLOCATION_TIME);
        this.appendLatency = this.makeTimer(JournalMetricsDoc.APPEND_LATENCY);
        this.appendRate = Counter.builder((String)JournalMetricsDoc.APPEND_RATE.getName()).description(JournalMetricsDoc.APPEND_RATE.getDescription()).register(registry);
        this.appendDataRate = Counter.builder((String)JournalMetricsDoc.APPEND_DATA_RATE.getName()).description(JournalMetricsDoc.APPEND_DATA_RATE.getDescription()).register(registry);
        this.seekLatency = this.makeTimer(JournalMetricsDoc.SEEK_LATENCY);
    }

    void observeSegmentCreation(Runnable segmentCreation) {
        this.segmentCreationTime.record(segmentCreation);
    }

    CloseableSilently observeSegmentFlush() {
        return MicrometerUtil.timer((Timer)this.segmentFlushTime, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    CloseableSilently observeJournalFlush() {
        return MicrometerUtil.timer((Timer)this.journalFlushTime, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    void observeSegmentTruncation(Runnable segmentTruncation) {
        this.segmentTruncateTime.record(segmentTruncation);
    }

    CloseableSilently startJournalOpenDurationTimer() {
        long now = this.registry.config().clock().monotonicTime();
        return () -> {
            long end = this.registry.config().clock().monotonicTime();
            this.journalOpenDuration.set(end - now);
        };
    }

    void incSegmentCount() {
        this.segmentCount.incrementAndGet();
    }

    void decSegmentCount() {
        this.segmentCount.decrementAndGet();
    }

    CloseableSilently observeSegmentAllocation() {
        return MicrometerUtil.timer((Timer)this.segmentAllocationTime, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    void observeAppend(long appendedBytes) {
        this.appendRate.increment();
        this.appendDataRate.increment((double)((float)appendedBytes / 1024.0f));
    }

    CloseableSilently observeAppendLatency() {
        return MicrometerUtil.timer((Timer)this.appendLatency, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    CloseableSilently observeSeekLatency() {
        return MicrometerUtil.timer((Timer)this.seekLatency, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    private Timer makeTimer(JournalMetricsDoc meter) {
        return Timer.builder((String)meter.getName()).description(meter.getDescription()).serviceLevelObjectives(meter.getTimerSLOs()).register(this.registry);
    }
}

