/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;

public enum JournalMetricsDoc implements ExtendedMeterDocumentation
{
    SEGMENT_CREATION_TIME{

        public String getName() {
            return "atomix.segment.creation.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Time spend to create a new segment";
        }

        public Duration[] getTimerSLOs() {
            return super.getTimerSLOs();
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    SEGMENT_TRUNCATE_TIME{

        public String getName() {
            return "atomix.segment.truncate.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Time spend to truncate a segment";
        }

        public Duration[] getTimerSLOs() {
            return super.getTimerSLOs();
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    SEGMENT_FLUSH_TIME{

        public String getName() {
            return "atomix.segment.flush.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Time spend to flush segment to disk";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    JOURNAL_FLUSH_TIME{

        public String getName() {
            return "atomix.journal.flush.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Time spend to flush all dirty segments to disk";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    SEGMENT_COUNT{

        public String getName() {
            return "atomix.segment.count";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "Number of segments";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    JOURNAL_OPERATION_DURATION{

        public String getName() {
            return "atomix.journal.open.time";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "Time taken to open the journal";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    SEGMENT_ALLOCATION_TIME{

        public String getName() {
            return "atomix.segment.allocation.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Time spent to allocate a new segment";
        }

        public Duration[] getTimerSLOs() {
            return super.getTimerSLOs();
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    APPEND_DATA_RATE{

        public String getName() {
            return "atomix.journal.append.data.rate";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "The rate in KiB at which we append data to the journal";
        }

        public String getBaseUnit() {
            return "KiB";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    APPEND_RATE{

        public String getName() {
            return "atomix.journal.append.rate";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "The rate at which we append entries in the journal, by entry count";
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    APPEND_LATENCY{

        public String getName() {
            return "atomix.journal.append.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Distribution of time spent appending journal records, excluding flushing";
        }

        public Duration[] getTimerSLOs() {
            return super.getTimerSLOs();
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    SEEK_LATENCY{
        private final Duration[] buckets = (Duration[])Stream.of(100, 1000, 5000, 100000, 25000, 50000, 75000, 1000000, 250000, 500000, 75000, 1000000, 2500000, 5000000).map(micros -> Duration.of(micros.intValue(), ChronoUnit.MICROS)).toArray(Duration[]::new);

        public String getName() {
            return "atomix.journal.seek.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Distribution of time spent seeking to a specific index";
        }

        public Duration[] getTimerSLOs() {
            return this.buckets;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    };

}

