/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.file.MessageHeaderDecoder;
import io.camunda.zeebe.journal.file.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class SegmentDescriptorDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 7;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "${project.version}";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SegmentDescriptorDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 3;
    }

    public int sbeSchemaId() {
        return 7;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SegmentDescriptorDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public SegmentDescriptorDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (3 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public SegmentDescriptorDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int idId() {
        return 1;
    }

    public static int idSinceVersion() {
        return 0;
    }

    public static int idEncodingOffset() {
        return 0;
    }

    public static int idEncodingLength() {
        return 8;
    }

    public static String idMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long idNullValue() {
        return Long.MIN_VALUE;
    }

    public static long idMinValue() {
        return -9223372036854775807L;
    }

    public static long idMaxValue() {
        return Long.MAX_VALUE;
    }

    public long id() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int indexId() {
        return 2;
    }

    public static int indexSinceVersion() {
        return 0;
    }

    public static int indexEncodingOffset() {
        return 8;
    }

    public static int indexEncodingLength() {
        return 8;
    }

    public static String indexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long indexNullValue() {
        return Long.MIN_VALUE;
    }

    public static long indexMinValue() {
        return -9223372036854775807L;
    }

    public static long indexMaxValue() {
        return Long.MAX_VALUE;
    }

    public long index() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int maxSegmentSizeId() {
        return 3;
    }

    public static int maxSegmentSizeSinceVersion() {
        return 0;
    }

    public static int maxSegmentSizeEncodingOffset() {
        return 16;
    }

    public static int maxSegmentSizeEncodingLength() {
        return 4;
    }

    public static String maxSegmentSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int maxSegmentSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int maxSegmentSizeMinValue() {
        return -2147483647;
    }

    public static int maxSegmentSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int maxSegmentSize() {
        return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastIndexId() {
        return 4;
    }

    public static int lastIndexSinceVersion() {
        return 2;
    }

    public static int lastIndexEncodingOffset() {
        return 20;
    }

    public static int lastIndexEncodingLength() {
        return 8;
    }

    public static String lastIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastIndexNullValue() {
        return -1L;
    }

    public static long lastIndexMinValue() {
        return 0L;
    }

    public static long lastIndexMaxValue() {
        return -2L;
    }

    public long lastIndex() {
        if (this.parentMessage.actingVersion < 2) {
            return -1L;
        }
        return this.buffer.getLong(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastPositionId() {
        return 5;
    }

    public static int lastPositionSinceVersion() {
        return 2;
    }

    public static int lastPositionEncodingOffset() {
        return 28;
    }

    public static int lastPositionEncodingLength() {
        return 4;
    }

    public static String lastPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastPositionNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long lastPositionMinValue() {
        return 0L;
    }

    public static long lastPositionMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long lastPosition() {
        if (this.parentMessage.actingVersion < 2) {
            return 0xFFFFFFFFL;
        }
        return (long)this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SegmentDescriptorDecoder decoder = new SegmentDescriptorDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SegmentDescriptor](sbeTemplateId=");
        builder.append(3);
        builder.append("|sbeSchemaId=");
        builder.append(7);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 2) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(2);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("id=");
        builder.append(this.id());
        builder.append('|');
        builder.append("index=");
        builder.append(this.index());
        builder.append('|');
        builder.append("maxSegmentSize=");
        builder.append(this.maxSegmentSize());
        builder.append('|');
        builder.append("lastIndex=");
        builder.append(this.lastIndex());
        builder.append('|');
        builder.append("lastPosition=");
        builder.append(this.lastPosition());
        this.limit(originalLimit);
        return builder;
    }

    public SegmentDescriptorDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

