/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.CorruptedJournalException;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.file.SegmentAllocator;
import io.camunda.zeebe.journal.file.SegmentDescriptor;
import io.camunda.zeebe.journal.file.SegmentDescriptorReader;
import io.camunda.zeebe.journal.file.SegmentFile;
import io.camunda.zeebe.journal.file.UninitializedSegment;
import io.camunda.zeebe.journal.file.UnknownVersionException;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.agrona.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SegmentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentLoader.class);
    private static final ByteOrder ENDIANNESS = ByteOrder.LITTLE_ENDIAN;
    private final SegmentAllocator allocator;
    private final long minFreeDiskSpace;
    private final JournalMetrics metrics;

    SegmentLoader(int minFreeDiskSpace, JournalMetrics metrics) {
        this(minFreeDiskSpace, metrics, SegmentAllocator.fill());
    }

    SegmentLoader(long minFreeDiskSpace, JournalMetrics metrics, SegmentAllocator allocator) {
        this.minFreeDiskSpace = minFreeDiskSpace;
        this.metrics = metrics;
        this.allocator = allocator;
    }

    Segment createSegment(Path segmentFile, SegmentDescriptor descriptor, long lastWrittenAsqn, JournalIndex journalIndex) {
        MappedByteBuffer mappedSegment;
        try {
            mappedSegment = this.mapNewSegment(segmentFile, descriptor);
        }
        catch (IOException e) {
            throw new JournalException(String.format("Failed to create new segment file %s", segmentFile), e);
        }
        try {
            descriptor.copyTo(mappedSegment);
            mappedSegment.force();
        }
        catch (InternalError e) {
            throw new JournalException(String.format("Failed to ensure durability of segment %s with descriptor %s, rolling back", segmentFile, descriptor), e);
        }
        try {
            FileUtil.flushDirectory((Path)segmentFile.getParent());
        }
        catch (IOException e) {
            throw new JournalException(String.format("Failed to flush journal directory after creating segment %s", segmentFile), e);
        }
        return this.loadSegment(segmentFile, mappedSegment, descriptor, lastWrittenAsqn, journalIndex);
    }

    UninitializedSegment createUninitializedSegment(Path segmentFile, SegmentDescriptor descriptor, JournalIndex journalIndex) {
        MappedByteBuffer mappedSegment;
        try {
            mappedSegment = this.mapNewSegment(segmentFile, descriptor);
        }
        catch (IOException e) {
            throw new JournalException(String.format("Failed to create new segment file %s", segmentFile), e);
        }
        try {
            FileUtil.flushDirectory((Path)segmentFile.getParent());
        }
        catch (IOException e) {
            throw new JournalException(String.format("Failed to flush journal directory after creating segment %s", segmentFile), e);
        }
        return new UninitializedSegment(new SegmentFile(segmentFile.toFile()), descriptor.id(), descriptor.maxSegmentSize(), mappedSegment, journalIndex);
    }

    Segment loadExistingSegment(Path segmentFile, long lastWrittenAsqn, JournalIndex journalIndex) {
        Segment segment;
        block9: {
            FileChannel channel = FileChannel.open(segmentFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
            try {
                long initialMappedLength = Files.size(segmentFile);
                MappedByteBuffer mappedSegment = this.mapSegment(channel, initialMappedLength);
                SegmentDescriptor descriptor = this.readDescriptor(mappedSegment, segmentFile.getFileName().toString());
                if ((long)descriptor.maxSegmentSize() > initialMappedLength) {
                    IoUtil.unmap((MappedByteBuffer)mappedSegment);
                    mappedSegment = this.mapSegment(channel, descriptor.maxSegmentSize());
                }
                segment = this.loadSegment(segmentFile, mappedSegment, descriptor, lastWrittenAsqn, journalIndex);
                if (channel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JournalException(String.format("Failed to load existing segment %s", segmentFile), e);
                }
            }
            channel.close();
        }
        return segment;
    }

    private Segment loadSegment(Path file, MappedByteBuffer buffer, SegmentDescriptor descriptor, long lastWrittenAsqn, JournalIndex journalIndex) {
        SegmentFile segmentFile = new SegmentFile(file.toFile());
        return new Segment(segmentFile, descriptor, buffer, lastWrittenAsqn, journalIndex, this.metrics);
    }

    private MappedByteBuffer mapSegment(FileChannel channel, long segmentSize) throws IOException {
        MappedByteBuffer mappedSegment = channel.map(FileChannel.MapMode.READ_WRITE, 0L, segmentSize);
        mappedSegment.order(ENDIANNESS);
        return mappedSegment;
    }

    private SegmentDescriptor readDescriptor(ByteBuffer buffer, String fileName) {
        try {
            return new SegmentDescriptorReader().readFrom(buffer);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JournalException(String.format("Expected to read descriptor of segment '%s', but nothing was read.", fileName), e);
        }
        catch (UnknownVersionException e) {
            throw new CorruptedJournalException(String.format("Couldn't read or recognize version of segment '%s'.", fileName), e);
        }
    }

    private MappedByteBuffer mapNewSegment(Path segmentPath, SegmentDescriptor descriptor) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        block8: {
            int maxSegmentSize = descriptor.maxSegmentSize();
            this.checkDiskSpace(segmentPath, maxSegmentSize);
            FileChannel channel = FileChannel.open(segmentPath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            try {
                this.allocateSegment(maxSegmentSize, channel);
                mappedByteBuffer = this.mapSegment(channel, maxSegmentSize);
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileAlreadyExistsException e) {
                    LOGGER.warn("Failed to create segment {}: an unused file already existed, and will be replaced", (Object)segmentPath, (Object)e);
                    Files.delete(segmentPath);
                    return this.mapNewSegment(segmentPath, descriptor);
                }
            }
            channel.close();
        }
        return mappedByteBuffer;
    }

    private void checkDiskSpace(Path segmentPath, int maxSegmentSize) {
        long required;
        long available = segmentPath.getParent().toFile().getUsableSpace();
        if (available < (required = Math.max((long)maxSegmentSize, this.minFreeDiskSpace))) {
            throw new JournalException.OutOfDiskSpace("Not enough space to allocate a new journal segment. Required: %s, Available: %s".formatted(required, available));
        }
    }

    private void allocateSegment(int maxSegmentSize, FileChannel channel) throws IOException {
        try (CloseableSilently ignored = this.metrics.observeSegmentAllocation();){
            this.allocator.allocate(channel, maxSegmentSize);
        }
    }
}

