/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.FrameUtil;
import io.camunda.zeebe.journal.file.IndexInfo;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.record.JournalRecordReaderUtil;
import io.camunda.zeebe.journal.record.SBESerializer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class SegmentReader
implements Iterator<JournalRecord> {
    private final ByteBuffer buffer;
    private final JournalIndex index;
    private final Segment segment;
    private long currentIndex;
    private final JournalRecordReaderUtil recordReader;
    private final int descriptorLength;

    SegmentReader(ByteBuffer buffer, Segment segment, JournalIndex index) {
        this.index = index;
        this.segment = segment;
        this.descriptorLength = segment.descriptor().length();
        this.recordReader = new JournalRecordReaderUtil(new SBESerializer());
        this.buffer = buffer;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (!this.segment.isOpen()) {
            return false;
        }
        return FrameUtil.hasValidVersion(this.buffer);
    }

    @Override
    public JournalRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        FrameUtil.readVersion(this.buffer);
        JournalRecord currentEntry = this.recordReader.read(this.buffer, this.getNextIndex());
        this.currentIndex = currentEntry.index();
        return currentEntry;
    }

    void reset() {
        this.buffer.position(this.descriptorLength);
        this.currentIndex = this.segment.index() - 1L;
    }

    void seek(long index) {
        boolean shouldIndex;
        this.checkSegmentOpen();
        long firstIndex = this.segment.index();
        long lastIndex = this.segment.lastIndex();
        this.reset();
        IndexInfo position = this.index.lookup(index - 1L);
        if (position != null && position.index() >= firstIndex && position.index() <= lastIndex) {
            this.buffer.position(position.position());
            this.currentIndex = position.index() - 1L;
        }
        boolean bl = shouldIndex = !this.index.hasIndexed(index);
        while (this.getNextIndex() < index && this.hasNext()) {
            int nextPosition = this.buffer.position();
            JournalRecord nextEntry = this.next();
            if (!shouldIndex) continue;
            this.index.index(nextEntry, nextPosition);
        }
    }

    void close() {
        this.segment.onReaderClosed(this);
    }

    long getNextIndex() {
        return this.currentIndex + 1L;
    }

    private void checkSegmentOpen() {
        Preconditions.checkState((boolean)this.segment.isOpen(), (Object)"Segment is already closed. Reader must reset to a valid index.");
    }
}

