/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.JournalReader;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.file.SegmentedJournalBuilder;
import io.camunda.zeebe.journal.file.SegmentedJournalReader;
import io.camunda.zeebe.journal.file.SegmentedJournalWriter;
import io.camunda.zeebe.journal.file.SegmentsFlusher;
import io.camunda.zeebe.journal.file.SegmentsManager;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.micrometer.core.instrument.MeterRegistry;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SegmentedJournal
implements Journal {
    public static final long ASQN_IGNORE = -1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentedJournal.class);
    private final JournalMetrics journalMetrics;
    private final Collection<SegmentedJournalReader> readers = Sets.newConcurrentHashSet();
    private volatile boolean open = true;
    private final JournalIndex journalIndex;
    private final SegmentedJournalWriter writer;
    private final StampedLock rwlock = new StampedLock();
    private final SegmentsManager segments;

    SegmentedJournal(JournalIndex journalIndex, SegmentsManager segments, JournalMetrics journalMetrics, SegmentsFlusher segmentsFlusher) {
        this.journalMetrics = Objects.requireNonNull(journalMetrics, "must specify journal metrics");
        this.journalIndex = Objects.requireNonNull(journalIndex, "must specify a journal index");
        this.segments = Objects.requireNonNull(segments, "must specify a journal segments manager");
        Objects.requireNonNull(segmentsFlusher, "must specify a segments flusher");
        this.segments.open();
        this.writer = new SegmentedJournalWriter(segments, segmentsFlusher, journalMetrics);
    }

    public static SegmentedJournalBuilder builder(MeterRegistry meterRegistry) {
        return new SegmentedJournalBuilder(meterRegistry);
    }

    @Override
    public JournalRecord append(BufferWriter recordDataWriter) {
        return this.append(-1L, recordDataWriter);
    }

    @Override
    public JournalRecord append(long asqn, BufferWriter recordDataWriter) {
        try (CloseableSilently ignored = this.journalMetrics.observeAppendLatency();){
            JournalRecord journalRecord = this.writer.append(asqn, recordDataWriter);
            return journalRecord;
        }
    }

    @Override
    public void append(JournalRecord record) {
        try (CloseableSilently ignored = this.journalMetrics.observeAppendLatency();){
            this.writer.append(record);
        }
    }

    @Override
    public JournalRecord append(long checksum, byte[] serializedRecord) {
        try (CloseableSilently ignored = this.journalMetrics.observeAppendLatency();){
            JournalRecord journalRecord = this.writer.append(checksum, serializedRecord);
            return journalRecord;
        }
    }

    @Override
    public void deleteAfter(long indexExclusive) {
        this.journalMetrics.observeSegmentTruncation(() -> {
            long stamp = this.rwlock.writeLock();
            try {
                this.writer.deleteAfter(indexExclusive);
                this.resetAdvancedReaders(indexExclusive + 1L);
            }
            finally {
                this.rwlock.unlockWrite(stamp);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUntil(long index) {
        long stamp = this.rwlock.writeLock();
        try {
            boolean bl = this.segments.deleteUntil(index);
            return bl;
        }
        finally {
            this.rwlock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(long nextIndex) {
        long stamp = this.rwlock.writeLock();
        try {
            this.journalIndex.clear();
            this.writer.reset(nextIndex);
        }
        finally {
            this.rwlock.unlockWrite(stamp);
        }
    }

    @Override
    public long getLastIndex() {
        return this.writer.getLastIndex();
    }

    @Override
    public long getFirstIndex() {
        Segment firstSegment = this.segments.getFirstSegment();
        return firstSegment != null ? firstSegment.index() : 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.writer.getNextIndex() - this.getFirstSegment().index() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (!this.isOpen() || this.isEmpty()) {
            LOGGER.debug("Skipped journal flush as it is either closed or empty");
            return;
        }
        try (CloseableSilently ignored = this.journalMetrics.observeJournalFlush();){
            long stamp = this.rwlock.readLock();
            try {
                this.writer.flush();
            }
            finally {
                this.rwlock.unlockRead(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JournalReader openReader() {
        long stamped = this.acquireReadlock();
        try {
            SegmentedJournalReader reader = new SegmentedJournalReader(this, this.journalMetrics);
            this.readers.add(reader);
            SegmentedJournalReader segmentedJournalReader = reader;
            return segmentedJournalReader;
        }
        finally {
            this.releaseReadlock(stamped);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public SortedMap<Long, Path> getTailSegments(long index) {
        SortedMap<Long, Segment> tailSegments = this.segments.getTailSegments(index);
        TreeMap treeMap = tailSegments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Segment)e.getValue()).file().file().toPath(), (a, b) -> b, TreeMap::new));
        return Collections.unmodifiableSortedMap(treeMap);
    }

    @Override
    public void close() {
        this.flush();
        this.segments.close();
        this.open = false;
    }

    private void assertOpen() {
        Preconditions.checkState((this.segments.getCurrentSegment() != null ? 1 : 0) != 0, (Object)"journal not open");
    }

    Segment getFirstSegment() {
        this.assertOpen();
        return this.segments.getFirstSegment();
    }

    Segment getLastSegment() {
        this.assertOpen();
        return this.segments.getLastSegment();
    }

    Segment getNextSegment(long index) {
        return this.segments.getNextSegment(index);
    }

    Segment getSegment(long index) {
        this.assertOpen();
        return this.segments.getSegment(index);
    }

    public void closeReader(SegmentedJournalReader segmentedJournalReader) {
        this.readers.remove(segmentedJournalReader);
    }

    void resetAdvancedReaders(long index) {
        for (SegmentedJournalReader reader : this.readers) {
            if (reader.getNextIndex() <= index) continue;
            reader.unsafeSeek(index);
        }
    }

    public JournalIndex getJournalIndex() {
        return this.journalIndex;
    }

    long acquireReadlock() {
        return this.rwlock.readLock();
    }

    void releaseReadlock(long stamp) {
        this.rwlock.unlockRead(stamp);
    }

    StampedLock rwlock() {
        return this.rwlock;
    }
}

