/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.journal.JournalMetaStore;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.SegmentAllocator;
import io.camunda.zeebe.journal.file.SegmentDescriptor;
import io.camunda.zeebe.journal.file.SegmentLoader;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import io.camunda.zeebe.journal.file.SegmentsFlusher;
import io.camunda.zeebe.journal.file.SegmentsManager;
import io.camunda.zeebe.journal.file.SparseJournalIndex;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;

public class SegmentedJournalBuilder {
    private static final String DEFAULT_NAME = "journal";
    private static final String DEFAULT_DIRECTORY = System.getProperty("user.dir");
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
    private static final long DEFAULT_MIN_FREE_DISK_SPACE = 0x40000000L;
    private static final int DEFAULT_JOURNAL_INDEX_DENSITY = 100;
    private static final boolean DEFAULT_PREALLOCATE_SEGMENT_FILES = true;
    private static final int DEFAULT_PARTITION_ID = -1;
    protected String name = "journal";
    protected File directory = new File(DEFAULT_DIRECTORY);
    protected int maxSegmentSize = 0x2000000;
    private long freeDiskSpace = 0x40000000L;
    private int journalIndexDensity = 100;
    private boolean preallocateSegmentFiles = true;
    private int partitionId = -1;
    private JournalMetaStore journalMetaStore;
    private final MeterRegistry meterRegistry;

    SegmentedJournalBuilder(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public SegmentedJournalBuilder withName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return this;
    }

    public SegmentedJournalBuilder withDirectory(String directory) {
        return this.withDirectory(new File((String)Preconditions.checkNotNull((Object)directory, (Object)"directory cannot be null")));
    }

    public SegmentedJournalBuilder withDirectory(File directory) {
        this.directory = (File)Preconditions.checkNotNull((Object)directory, (Object)"directory cannot be null");
        return this;
    }

    public SegmentedJournalBuilder withMaxSegmentSize(int maxSegmentSize) {
        Preconditions.checkArgument((maxSegmentSize > SegmentDescriptor.getEncodingLength() ? 1 : 0) != 0, (Object)("maxSegmentSize must be greater than " + SegmentDescriptor.getEncodingLength()));
        this.maxSegmentSize = maxSegmentSize;
        return this;
    }

    public SegmentedJournalBuilder withFreeDiskSpace(long freeDiskSpace) {
        Preconditions.checkArgument((freeDiskSpace >= 0L ? 1 : 0) != 0, (Object)"minFreeDiskSpace must be positive");
        this.freeDiskSpace = freeDiskSpace;
        return this;
    }

    public SegmentedJournalBuilder withJournalIndexDensity(int journalIndexDensity) {
        this.journalIndexDensity = journalIndexDensity;
        return this;
    }

    public SegmentedJournalBuilder withPreallocateSegmentFiles(boolean preallocateSegmentFiles) {
        this.preallocateSegmentFiles = preallocateSegmentFiles;
        return this;
    }

    public SegmentedJournalBuilder withPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public SegmentedJournalBuilder withMetaStore(JournalMetaStore metaStore) {
        this.journalMetaStore = metaStore;
        return this;
    }

    public SegmentedJournal build() {
        SparseJournalIndex journalIndex = new SparseJournalIndex(this.journalIndexDensity);
        JournalMetrics journalMetrics = new JournalMetrics(this.meterRegistry);
        SegmentAllocator segmentAllocator = this.preallocateSegmentFiles ? SegmentAllocator.fill() : SegmentAllocator.noop();
        SegmentLoader segmentLoader = new SegmentLoader(this.freeDiskSpace, journalMetrics, segmentAllocator);
        SegmentsManager segmentsManager = new SegmentsManager(journalIndex, this.maxSegmentSize, this.directory, this.name, segmentLoader, journalMetrics, this.journalMetaStore);
        SegmentsFlusher segmentsFlusher = new SegmentsFlusher(this.journalMetaStore);
        return new SegmentedJournal(journalIndex, segmentsManager, journalMetrics, segmentsFlusher);
    }
}

