/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalReader;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalMetrics;
import io.camunda.zeebe.journal.file.Segment;
import io.camunda.zeebe.journal.file.SegmentReader;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import io.camunda.zeebe.util.CloseableSilently;
import java.util.NoSuchElementException;

class SegmentedJournalReader
implements JournalReader {
    private final SegmentedJournal journal;
    private Segment currentSegment;
    private SegmentReader currentReader;
    private final JournalMetrics metrics;

    SegmentedJournalReader(SegmentedJournal journal, JournalMetrics journalMetrics) {
        this.journal = journal;
        this.metrics = journalMetrics;
        this.initialize();
    }

    private void initialize() {
        this.currentSegment = this.journal.getFirstSegment();
        this.currentReader = this.currentSegment.createReader();
    }

    public long getNextIndex() {
        return this.currentReader.getNextIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        long stamp = this.journal.acquireReadlock();
        try {
            boolean bl = this.unsafeHasNext();
            return bl;
        }
        finally {
            this.journal.releaseReadlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JournalRecord next() {
        long stamp = this.journal.acquireReadlock();
        try {
            JournalRecord journalRecord = this.unsafeNext();
            return journalRecord;
        }
        finally {
            this.journal.releaseReadlock(stamp);
        }
    }

    private JournalRecord unsafeNext() throws NoSuchElementException {
        if (!this.unsafeHasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentReader.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seek(long index) {
        try (CloseableSilently ignored = this.metrics.observeSeekLatency();){
            long stamp = this.journal.acquireReadlock();
            try {
                long l = this.unsafeSeek(index);
                this.journal.releaseReadlock(stamp);
                return l;
            }
            catch (Throwable throwable) {
                this.journal.releaseReadlock(stamp);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekToFirst() {
        try (CloseableSilently ignored = this.metrics.observeSeekLatency();){
            long stamp = this.journal.acquireReadlock();
            try {
                long l = this.unsafeSeekToFirst();
                this.journal.releaseReadlock(stamp);
                return l;
            }
            catch (Throwable throwable) {
                this.journal.releaseReadlock(stamp);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekToLast() {
        try (CloseableSilently ignored = this.metrics.observeSeekLatency();){
            long stamp = this.journal.acquireReadlock();
            try {
                long l = this.unsafeSeekToLast();
                this.journal.releaseReadlock(stamp);
                return l;
            }
            catch (Throwable throwable) {
                this.journal.releaseReadlock(stamp);
                throw throwable;
            }
        }
    }

    @Override
    public long seekToAsqn(long asqn) {
        return this.seekToAsqn(asqn, this.journal.getLastIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekToAsqn(long asqn, long indexUpperBound) {
        try (CloseableSilently ignored = this.metrics.observeSeekLatency();){
            JournalRecord record;
            long stamp;
            block15: {
                stamp = this.journal.acquireReadlock();
                try {
                    JournalRecord currentRecord;
                    JournalIndex journalIndex = this.journal.getJournalIndex();
                    Long index = journalIndex.lookupAsqn(asqn, indexUpperBound);
                    if (index == null) {
                        this.unsafeSeekToFirst();
                    } else {
                        this.unsafeSeek(index);
                    }
                    record = null;
                    while (this.unsafeHasNext() && (currentRecord = this.next()).index() <= indexUpperBound) {
                        if (currentRecord.asqn() <= asqn && currentRecord.asqn() != -1L) {
                            record = currentRecord;
                            continue;
                        }
                        if (currentRecord.asqn() < asqn) continue;
                        break;
                    }
                    if (record != null) break block15;
                    long l = this.unsafeSeekToFirst();
                    this.journal.releaseReadlock(stamp);
                    return l;
                }
                catch (Throwable throwable) {
                    this.journal.releaseReadlock(stamp);
                    throw throwable;
                }
            }
            long l = this.unsafeSeek(record.index());
            this.journal.releaseReadlock(stamp);
            return l;
        }
    }

    @Override
    public void close() {
        this.currentReader.close();
        this.journal.closeReader(this);
    }

    long unsafeSeek(long index) {
        if (!this.currentSegment.isOpen()) {
            this.unsafeSeekToFirst();
        }
        if (index < this.currentReader.getNextIndex()) {
            this.rewind(index);
        } else if (index > this.currentReader.getNextIndex()) {
            this.forward(index);
        } else {
            this.currentReader.seek(index);
        }
        return this.getNextIndex();
    }

    private long unsafeSeekToFirst() {
        this.replaceCurrentSegment(this.journal.getFirstSegment());
        return this.journal.getFirstIndex();
    }

    private long unsafeSeekToLast() {
        this.replaceCurrentSegment(this.journal.getLastSegment());
        this.unsafeSeek(this.journal.getLastIndex());
        return this.journal.getLastIndex();
    }

    private void rewind(long index) {
        long lookupIndex;
        Segment segment;
        if (this.currentSegment.index() >= index && (segment = this.journal.getSegment(lookupIndex = index == Long.MIN_VALUE ? index : index - 1L)) != null) {
            this.replaceCurrentSegment(segment);
        }
        this.currentReader.seek(index);
    }

    private void forward(long index) {
        Segment segment;
        if (!this.currentSegment.equals(this.journal.getLastSegment()) && (segment = this.journal.getSegment(index)) != null && !segment.equals(this.currentSegment)) {
            this.replaceCurrentSegment(segment);
        }
        this.currentReader.seek(index);
    }

    private boolean unsafeHasNext() {
        if (!this.currentReader.hasNext()) {
            if (!this.currentSegment.isOpen()) {
                return false;
            }
            Segment nextSegment = this.journal.getNextSegment(this.currentSegment.index());
            if (nextSegment != null && nextSegment.index() == this.getNextIndex()) {
                this.replaceCurrentSegment(nextSegment);
                return this.currentReader.hasNext();
            }
            return false;
        }
        return true;
    }

    private void replaceCurrentSegment(Segment nextSegment) {
        if (this.currentSegment.equals(nextSegment)) {
            this.currentReader.reset();
            return;
        }
        this.currentReader.close();
        this.currentSegment = nextSegment;
        this.currentReader = this.currentSegment.createReader();
    }
}

