/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.file.MessageHeaderEncoder;
import io.camunda.zeebe.journal.file.MetaAttribute;
import io.camunda.zeebe.journal.file.RecordDataDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class RecordDataEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 7;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "${project.version}";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordDataEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 7;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RecordDataEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 16);
        return this;
    }

    public RecordDataEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(16).templateId(2).schemaId(7).version(2);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int indexId() {
        return 1;
    }

    public static int indexSinceVersion() {
        return 0;
    }

    public static int indexEncodingOffset() {
        return 0;
    }

    public static int indexEncodingLength() {
        return 8;
    }

    public static String indexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long indexNullValue() {
        return -1L;
    }

    public static long indexMinValue() {
        return 0L;
    }

    public static long indexMaxValue() {
        return -2L;
    }

    public RecordDataEncoder index(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int asqnId() {
        return 2;
    }

    public static int asqnSinceVersion() {
        return 0;
    }

    public static int asqnEncodingOffset() {
        return 8;
    }

    public static int asqnEncodingLength() {
        return 8;
    }

    public static String asqnMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long asqnNullValue() {
        return Long.MIN_VALUE;
    }

    public static long asqnMinValue() {
        return -9223372036854775807L;
    }

    public static long asqnMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordDataEncoder asqn(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int dataId() {
        return 3;
    }

    public static String dataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int dataHeaderLength() {
        return 4;
    }

    public RecordDataEncoder putData(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordDataEncoder putData(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        RecordDataDecoder decoder = new RecordDataDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 16, 2);
        return decoder.appendTo(builder);
    }
}

