/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.CorruptedJournalException;
import io.camunda.zeebe.journal.file.DescriptorMetadataDecoder;
import io.camunda.zeebe.journal.file.MessageHeaderDecoder;
import io.camunda.zeebe.journal.file.SegmentDescriptor;
import io.camunda.zeebe.journal.file.SegmentDescriptorDecoder;
import io.camunda.zeebe.journal.file.UnknownVersionException;
import io.camunda.zeebe.journal.util.ChecksumGenerator;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class SegmentDescriptorReader {
    private final DescriptorMetadataDecoder metadataDecoder = new DescriptorMetadataDecoder();
    private final SegmentDescriptorDecoder segmentDescriptorDecoder = new SegmentDescriptorDecoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ChecksumGenerator checksumGen = new ChecksumGenerator();
    private final DirectBuffer directBuffer = new UnsafeBuffer();
    private int actingSchemaVersion = this.segmentDescriptorDecoder.sbeSchemaVersion();
    private long id;
    private long index;
    private int maxSegmentSize;
    private long lastIndex;
    private int lastPosition;
    private int encodedLength;
    private long checksum;

    SegmentDescriptorReader() {
    }

    SegmentDescriptor readFrom(ByteBuffer buffer) {
        byte version;
        this.directBuffer.wrap(buffer);
        try {
            version = this.directBuffer.getByte(0);
            if (version < 2 || version > 2) {
                throw new UnknownVersionException(String.format("Expected version to be one (%d %d] but read %d instead.", (byte)2, (byte)2, version));
            }
            this.readV2Descriptor(this.directBuffer);
        }
        catch (IndexOutOfBoundsException error) {
            throw new CorruptedJournalException("Failed to read segment descriptor", error);
        }
        return new SegmentDescriptor(version, this.actingSchemaVersion, this.id, this.index, this.maxSegmentSize, this.lastIndex, this.lastPosition, this.encodedLength);
    }

    private void readV2Descriptor(DirectBuffer buffer) {
        this.validateHeader(buffer, 1, this.metadataDecoder.sbeSchemaId(), this.metadataDecoder.sbeTemplateId());
        int descHeaderOffset = this.readChecksum(buffer, 1);
        this.validateHeader(buffer, descHeaderOffset, this.segmentDescriptorDecoder.sbeSchemaId(), this.segmentDescriptorDecoder.sbeTemplateId());
        int totalLength = this.readDescriptor(buffer, descHeaderOffset);
        int descriptorLength = totalLength - descHeaderOffset;
        this.validateChecksum(buffer, descHeaderOffset, descriptorLength);
    }

    private void validateChecksum(DirectBuffer buffer, int descHeaderOffset, int descriptorLength) {
        ByteBuffer slice = ByteBuffer.allocate(descriptorLength);
        buffer.getBytes(descHeaderOffset, slice, descriptorLength);
        long computedChecksum = this.checksumGen.compute(slice, 0, descriptorLength);
        if (computedChecksum != this.checksum) {
            throw new CorruptedJournalException("Descriptor doesn't match checksum (possibly due to corruption).");
        }
    }

    private int readDescriptor(DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        this.actingSchemaVersion = this.headerDecoder.version();
        this.segmentDescriptorDecoder.wrap(this.directBuffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.actingSchemaVersion);
        this.id = this.segmentDescriptorDecoder.id();
        this.index = this.segmentDescriptorDecoder.index();
        this.maxSegmentSize = this.segmentDescriptorDecoder.maxSegmentSize();
        this.lastIndex = Math.max(0L, this.segmentDescriptorDecoder.lastIndex());
        this.lastPosition = Math.max(0, (int)this.segmentDescriptorDecoder.lastPosition());
        this.encodedLength = offset + this.headerDecoder.encodedLength() + this.segmentDescriptorDecoder.encodedLength();
        return this.encodedLength;
    }

    private int readChecksum(DirectBuffer buffer, int offset) {
        this.headerDecoder.wrap(buffer, offset);
        this.metadataDecoder.wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.checksum = this.metadataDecoder.checksum();
        return offset + this.headerDecoder.encodedLength() + this.metadataDecoder.encodedLength();
    }

    private void validateHeader(DirectBuffer buffer, int offset, int schemaId, int templateId) {
        this.headerDecoder.wrap(buffer, offset);
        if (this.headerDecoder.schemaId() != schemaId || this.headerDecoder.templateId() != templateId) {
            throw new CorruptedJournalException(String.format("Cannot read header. Read schema and template ids ('%d' and '%d') don't match expected '%d' and %d'.", this.headerDecoder.schemaId(), this.headerDecoder.templateId(), schemaId, templateId));
        }
    }
}

