/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.file.DescriptorMetadataDecoder;
import io.camunda.zeebe.journal.file.MessageHeaderEncoder;
import io.camunda.zeebe.journal.file.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class DescriptorMetadataEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 7;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "${project.version}";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final DescriptorMetadataEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 4;
    }

    public int sbeSchemaId() {
        return 7;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public DescriptorMetadataEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public DescriptorMetadataEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(8).templateId(4).schemaId(7).version(2);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int checksumId() {
        return 1;
    }

    public static int checksumSinceVersion() {
        return 0;
    }

    public static int checksumEncodingOffset() {
        return 0;
    }

    public static int checksumEncodingLength() {
        return 8;
    }

    public static String checksumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long checksumNullValue() {
        return Long.MIN_VALUE;
    }

    public static long checksumMinValue() {
        return -9223372036854775807L;
    }

    public static long checksumMaxValue() {
        return Long.MAX_VALUE;
    }

    public DescriptorMetadataEncoder checksum(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        DescriptorMetadataDecoder decoder = new DescriptorMetadataDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 8, 2);
        return decoder.appendTo(builder);
    }
}

