/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.backpressure;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.camunda.zeebe.logstreams.impl.Loggers;
import io.camunda.zeebe.logstreams.impl.backpressure.AppendBackpressureMetrics;
import io.camunda.zeebe.logstreams.impl.backpressure.AppendLimiter;
import java.util.Optional;
import org.agrona.collections.Long2ObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppendEntryLimiter
extends AbstractLimiter<Long>
implements AppendLimiter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.logstreams.impl.backpressure");
    private final Long2ObjectHashMap<Limiter.Listener> appendedListeners = new Long2ObjectHashMap();
    private final AppendBackpressureMetrics metrics;

    private AppendEntryLimiter(AppendEntryLimiterBuilder builder, int partitionId) {
        super((AbstractLimiter.Builder)builder);
        this.metrics = new AppendBackpressureMetrics(partitionId);
        this.metrics.setInflight(0);
        this.metrics.setNewLimit(this.getLimit());
    }

    public Optional<Limiter.Listener> acquire(Long position) {
        if (this.getInflight() >= this.getLimit()) {
            return this.createRejectedListener();
        }
        Limiter.Listener listener = this.createListener();
        return Optional.of(listener);
    }

    private void registerListener(long position, Limiter.Listener listener) {
        this.appendedListeners.put(position, (Object)listener);
    }

    @Override
    public boolean tryAcquire(Long position) {
        Optional<Limiter.Listener> acquired = this.acquire(position);
        return acquired.map(listener -> {
            this.registerListener(position, (Limiter.Listener)listener);
            this.metrics.incInflight();
            return true;
        }).orElse(false);
    }

    @Override
    public void onCommit(long position) {
        Limiter.Listener listener = (Limiter.Listener)this.appendedListeners.remove(position);
        if (listener != null) {
            try {
                listener.onSuccess();
            }
            catch (IllegalArgumentException e) {
                listener.onIgnore();
                LOG.warn("Could not register request RTT (likely caused by clock problems). Consider using the 'fixed' backpressure algorithm.", (Throwable)e);
            }
            this.metrics.decInflight();
        } else {
            Loggers.LOGSTREAMS_LOGGER.warn("We encountered an problem on releasing the acquired in flight append. There was no listener registered for the given position {}, this should not happen.", (Object)position);
        }
    }

    protected void onNewLimit(int newLimit) {
        super.onNewLimit(newLimit);
        this.metrics.setNewLimit(newLimit);
    }

    public static AppendEntryLimiterBuilder builder() {
        return new AppendEntryLimiterBuilder();
    }

    public static class AppendEntryLimiterBuilder
    extends AbstractLimiter.Builder<AppendEntryLimiterBuilder> {
        private int partitionId;

        protected AppendEntryLimiterBuilder self() {
            return this;
        }

        public AppendEntryLimiterBuilder partitionId(int partition) {
            this.partitionId = partition;
            return this;
        }

        public AppendEntryLimiter build() {
            return new AppendEntryLimiter(this, this.partitionId);
        }
    }
}

