/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.storage.atomix;

import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixAppendListenerAdapter;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorageReader;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixReaderFactory;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AtomixLogStorage
implements LogStorage,
RaftCommitListener {
    private final AtomixReaderFactory readerFactory;
    private final ZeebeLogAppender logAppender;
    private final Set<LogStorage.CommitListener> commitListeners = new CopyOnWriteArraySet<LogStorage.CommitListener>();

    public AtomixLogStorage(AtomixReaderFactory readerFactory, ZeebeLogAppender logAppender) {
        this.readerFactory = readerFactory;
        this.logAppender = logAppender;
    }

    public static AtomixLogStorage ofPartition(AtomixReaderFactory readerFactory, ZeebeLogAppender appender) {
        return new AtomixLogStorage(readerFactory, appender);
    }

    @Override
    public AtomixLogStorageReader newReader() {
        return new AtomixLogStorageReader(this.readerFactory.create());
    }

    @Override
    public void append(long lowestPosition, long highestPosition, ByteBuffer buffer, LogStorage.AppendListener listener) {
        AtomixAppendListenerAdapter adapter = new AtomixAppendListenerAdapter(listener);
        this.logAppender.appendEntry(lowestPosition, highestPosition, buffer, (ZeebeLogAppender.AppendListener)adapter);
    }

    @Override
    public void addCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.add(listener);
    }

    @Override
    public void removeCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.remove(listener);
    }

    public void onCommit(long index) {
        this.commitListeners.forEach(LogStorage.CommitListener::onCommit);
    }
}

