/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum AppendMetricsDoc implements ExtendedMeterDocumentation
{
    TOTAL_DEFERRED_APPEND_COUNT{

        public String getDescription() {
            return "Number of deferred appends due to backpressure";
        }

        public String getName() {
            return "zeebe.deferred.append.count.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    TOTAL_APPEND_TRY_COUNT{

        public String getDescription() {
            return "Number of tries to append";
        }

        public String getName() {
            return "zeebe.try.to.append.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    CURRENT_INFLIGHT{

        public String getDescription() {
            return "Current number of append inflight";
        }

        public String getName() {
            return "zeebe.backpressure.inflight.append.count";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    CURRENT_LIMIT{

        public String getDescription() {
            return "Current limit for number of inflight appends";
        }

        public String getName() {
            return "zeebe.backpressure.append.limit";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    LAST_COMMITTED_POSITION{

        public String getDescription() {
            return "The last committed position";
        }

        public String getName() {
            return "zeebe.log.appender.last.committed.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    LAST_WRITTEN_POSITION{

        public String getDescription() {
            return "The last appended position by the appender";
        }

        public String getName() {
            return "zeebe.log.appender.last.appended.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    WRITE_LATENCY{

        public String getDescription() {
            return "Latency to append an event to the log in seconds";
        }

        public String getName() {
            return "zeebe.log.appender.append.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    COMMIT_LATENCY{

        public String getDescription() {
            return "Latency to commit an event to the log in seconds";
        }

        public String getName() {
            return "zeebe.log.appender.commit.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION};
        }
    }
    ,
    RECORD_APPENDED{

        public String getDescription() {
            return "Count of records appended per partition, record type, value type, and intent";
        }

        public String getName() {
            return "zeebe.log.appender.record.appended";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{RecordAppendedKeyNames.values(), {MicrometerUtil.PartitionKeyNames.PARTITION}});
        }
    };


    public static enum RecordAppendedKeyNames implements KeyName
    {
        RECORD_TYPE{

            public String asString() {
                return "recordType";
            }
        }
        ,
        VALUE_TYPE{

            public String asString() {
                return "valueType";
            }
        }
        ,
        INTENT{

            public String asString() {
                return "intent";
            }
        };

    }
}

