/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import io.camunda.zeebe.logstreams.impl.flowcontrol.AppendMetricsDoc;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.collection.Map3D;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;

public final class AppenderMetrics {
    private final Map3D<RecordType, ValueType, Intent, Counter> recordAppended = Map3D.simple();
    private final AtomicLong inflightAppends = new AtomicLong();
    private final AtomicLong inflightLimit = new AtomicLong();
    private final AtomicLong lastCommitted = new AtomicLong();
    private final AtomicLong lastWritten = new AtomicLong();
    private final MeterRegistry registry;
    private final Counter deferredAppends;
    private final Counter triedAppends;
    private final Timer commitLatency;
    private final Timer appendLatency;

    public AppenderMetrics(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
        this.deferredAppends = Counter.builder((String)AppendMetricsDoc.TOTAL_DEFERRED_APPEND_COUNT.getName()).description(AppendMetricsDoc.TOTAL_DEFERRED_APPEND_COUNT.getDescription()).register(this.registry);
        this.triedAppends = Counter.builder((String)AppendMetricsDoc.TOTAL_APPEND_TRY_COUNT.getName()).description(AppendMetricsDoc.TOTAL_APPEND_TRY_COUNT.getDescription()).register(this.registry);
        this.commitLatency = Timer.builder((String)AppendMetricsDoc.COMMIT_LATENCY.getName()).description(AppendMetricsDoc.COMMIT_LATENCY.getDescription()).serviceLevelObjectives(AppendMetricsDoc.COMMIT_LATENCY.getTimerSLOs()).register(this.registry);
        this.appendLatency = Timer.builder((String)AppendMetricsDoc.WRITE_LATENCY.getName()).description(AppendMetricsDoc.WRITE_LATENCY.getDescription()).serviceLevelObjectives(AppendMetricsDoc.WRITE_LATENCY.getTimerSLOs()).register(this.registry);
        Gauge.builder((String)AppendMetricsDoc.CURRENT_INFLIGHT.getName(), (Object)this.inflightAppends, Number::longValue).description(AppendMetricsDoc.CURRENT_INFLIGHT.getDescription()).register(this.registry);
        Gauge.builder((String)AppendMetricsDoc.CURRENT_LIMIT.getName(), (Object)this.inflightLimit, Number::longValue).description(AppendMetricsDoc.CURRENT_LIMIT.getDescription()).register(this.registry);
        Gauge.builder((String)AppendMetricsDoc.LAST_COMMITTED_POSITION.getName(), (Object)this.lastCommitted, Number::longValue).description(AppendMetricsDoc.LAST_COMMITTED_POSITION.getDescription()).register(this.registry);
        Gauge.builder((String)AppendMetricsDoc.LAST_WRITTEN_POSITION.getName(), (Object)this.lastWritten, Number::longValue).description(AppendMetricsDoc.LAST_WRITTEN_POSITION.getDescription()).register(this.registry);
    }

    public void increaseInflight() {
        this.inflightAppends.incrementAndGet();
    }

    public void decreaseInflight() {
        this.inflightAppends.decrementAndGet();
    }

    public void setInflightLimit(long limit) {
        this.inflightLimit.set(limit);
    }

    public void increaseTriedAppends() {
        this.triedAppends.increment();
    }

    public void increaseDeferredAppends() {
        this.deferredAppends.increment();
    }

    public CloseableSilently startWriteTimer() {
        return MicrometerUtil.timer((Timer)this.appendLatency, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    public CloseableSilently startCommitTimer() {
        return MicrometerUtil.timer((Timer)this.commitLatency, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    public void setLastWrittenPosition(long position) {
        this.lastWritten.set(position);
    }

    public void setLastCommittedPosition(long position) {
        this.lastCommitted.set(position);
    }

    public void recordAppendedEntry(int amount, RecordType recordType, ValueType valueType, Intent intent) {
        ((Counter)this.recordAppended.computeIfAbsent((Object)recordType, (Object)valueType, (Object)intent, this::registerRecordAppendedCounter)).increment((double)amount);
    }

    private Counter registerRecordAppendedCounter(RecordType recordType, ValueType valueType, Intent intent) {
        return Counter.builder((String)AppendMetricsDoc.RECORD_APPENDED.getName()).description(AppendMetricsDoc.RECORD_APPENDED.getDescription()).tag(AppendMetricsDoc.RecordAppendedKeyNames.RECORD_TYPE.asString(), recordType.name()).tag(AppendMetricsDoc.RecordAppendedKeyNames.VALUE_TYPE.asString(), valueType.name()).tag(AppendMetricsDoc.RecordAppendedKeyNames.INTENT.asString(), intent.name()).register(this.registry);
    }
}

