/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.camunda.zeebe.logstreams.impl.flowcontrol.AppenderMetrics;
import java.util.Optional;

final class AppendLimiter
extends AbstractLimiter<Void> {
    private final AppenderMetrics metrics;

    private AppendLimiter(AbstractLimiter.Builder<?> builder, AppenderMetrics metrics) {
        super(builder);
        this.metrics = metrics;
        metrics.setInflightLimit(this.getLimit());
    }

    public static AppenderLimiterBuilder builder() {
        return new AppenderLimiterBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Limiter.Listener> acquire(Void context) {
        AppendLimiter appendLimiter = this;
        synchronized (appendLimiter) {
            if (this.getInflight() < this.getLimit()) {
                return Optional.of(this.createListener());
            }
        }
        return this.createRejectedListener();
    }

    protected void onNewLimit(int newLimit) {
        super.onNewLimit(newLimit);
        this.metrics.setInflightLimit(newLimit);
    }

    static final class AppenderLimiterBuilder
    extends AbstractLimiter.Builder<AppenderLimiterBuilder> {
        private AppenderMetrics metrics;

        AppenderLimiterBuilder() {
        }

        public AppenderLimiterBuilder metrics(AppenderMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public AppendLimiter build() {
            return new AppendLimiter(this, this.metrics);
        }

        protected AppenderLimiterBuilder self() {
            return this;
        }
    }
}

