/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.log.LogStreamImpl;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Objects;

public final class LogStreamBuilderImpl
implements LogStreamBuilder {
    private static final int MINIMUM_FRAGMENT_SIZE = 4096;
    private int maxFragmentSize = 0x400000;
    private int partitionId = -1;
    private ActorSchedulingService actorSchedulingService;
    private LogStorage logStorage;
    private String logName;
    private int nodeId = 0;
    private MeterRegistry meterRegistry = new SimpleMeterRegistry();

    @Override
    public LogStreamBuilder withActorSchedulingService(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
        return this;
    }

    @Override
    public LogStreamBuilder withMaxFragmentSize(int maxFragmentSize) {
        this.maxFragmentSize = maxFragmentSize;
        return this;
    }

    @Override
    public LogStreamBuilder withLogStorage(LogStorage logStorage) {
        this.logStorage = logStorage;
        return this;
    }

    @Override
    public LogStreamBuilder withPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @Override
    public LogStreamBuilder withNodeId(int nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Override
    public LogStreamBuilder withLogName(String logName) {
        this.logName = logName;
        return this;
    }

    @Override
    public LogStreamBuilder withMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    @Override
    public ActorFuture<LogStream> buildAsync() {
        this.validate();
        LogStreamImpl logStreamService = new LogStreamImpl(this.actorSchedulingService, this.logName, this.partitionId, this.nodeId, this.maxFragmentSize, this.logStorage, this.meterRegistry);
        CompletableActorFuture logstreamInstallFuture = new CompletableActorFuture();
        this.actorSchedulingService.submitActor((Actor)logStreamService).onComplete((v, t) -> {
            if (t == null) {
                logstreamInstallFuture.complete((Object)logStreamService);
            } else {
                logstreamInstallFuture.completeExceptionally(t);
            }
        });
        return logstreamInstallFuture;
    }

    private void validate() {
        Objects.requireNonNull(this.actorSchedulingService, "Must specify a actor scheduler");
        Objects.requireNonNull(this.logStorage, "Must specify a log storage");
        if (this.maxFragmentSize < 4096) {
            throw new IllegalArgumentException(String.format("Expected fragment size to be at least '%d', but was '%d'", 4096, this.maxFragmentSize));
        }
    }
}

