/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import java.time.Duration;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.LongSupplier;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class RateMeasurement {
    private final LongSupplier clock;
    private final LinkedBlockingDeque<Observation> observations;
    private final long resolution;
    private volatile long currentValue;

    public RateMeasurement(LongSupplier clock, Duration observationWindow, Duration resolution) {
        if (observationWindow.isNegative() || resolution.isNegative()) {
            throw new IllegalArgumentException("observationWindow and resolution must be positive");
        }
        if (observationWindow.compareTo(resolution) <= 0) {
            throw new IllegalArgumentException("observationWindow must be greater than resolution");
        }
        this.clock = clock;
        this.resolution = resolution.toMillis();
        int numberOfObservations = (int)(observationWindow.toMillis() / this.resolution);
        this.observations = new LinkedBlockingDeque(numberOfObservations);
    }

    public boolean observe(long value) {
        long now = this.clock.getAsLong();
        this.currentValue = value;
        return this.updateObservations(now, value);
    }

    public long rate() {
        long now = this.clock.getAsLong();
        Observation oldest = this.observations.peekFirst();
        if (oldest == null) {
            return 0L;
        }
        long elapsed = now - oldest.timestamp;
        if (elapsed == 0L) {
            return 0L;
        }
        long delta = this.currentValue - oldest.value;
        return delta * 1000L / elapsed;
    }

    private boolean updateObservations(long now, long value) {
        Observation last = this.observations.peekLast();
        if (last == null || now - last.timestamp >= this.resolution) {
            Observation newObservation = new Observation(now, value);
            while (!this.observations.offerLast(newObservation)) {
                this.observations.removeFirst();
            }
            return true;
        }
        return false;
    }

    record Observation(long timestamp, long value) {
    }
}

