/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.serializer.DataFrameDescriptor;
import io.camunda.zeebe.protocol.Protocol;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class LogEntryDescriptor {
    public static final long KEY_NULL_VALUE = -1L;
    private static final short VERSION = 1;
    private static final int VERSION_OFFSET;
    private static final int FLAGS_OFFSET;
    private static final int POSITION_OFFSET;
    private static final int SOURCE_EVENT_POSITION_OFFSET;
    private static final int KEY_OFFSET;
    private static final int TIMESTAMP_OFFSET;
    private static final int METADATA_LENGTH_OFFSET;
    private static final int HEADER_BLOCK_LENGTH;
    private static final int METADATA_OFFSET;

    public static int versionOffset(int offset) {
        return VERSION_OFFSET + offset;
    }

    public static void setVersion(MutableDirectBuffer buffer, int offset) {
        buffer.putShort(LogEntryDescriptor.versionOffset(offset), (short)1, Protocol.ENDIANNESS);
    }

    public static short getVersion(DirectBuffer buffer, int offset) {
        return buffer.getShort(LogEntryDescriptor.versionOffset(offset), Protocol.ENDIANNESS);
    }

    public static int getFragmentLength(DirectBuffer buffer, int offset) {
        return DataFrameDescriptor.alignedLength(buffer.getInt(DataFrameDescriptor.lengthOffset(offset), Protocol.ENDIANNESS));
    }

    public static int headerLength(int metadataLength) {
        return HEADER_BLOCK_LENGTH + metadataLength;
    }

    public static int positionOffset(int offset) {
        return POSITION_OFFSET + offset;
    }

    public static long getPosition(DirectBuffer buffer, int offset) {
        return buffer.getLong(LogEntryDescriptor.positionOffset(DataFrameDescriptor.messageOffset(offset)), Protocol.ENDIANNESS);
    }

    public static void setPosition(MutableDirectBuffer buffer, int offset, long position) {
        buffer.putLong(LogEntryDescriptor.positionOffset(offset), position, Protocol.ENDIANNESS);
    }

    public static int sourceEventPositionOffset(int offset) {
        return SOURCE_EVENT_POSITION_OFFSET + offset;
    }

    public static long getSourceEventPosition(DirectBuffer buffer, int offset) {
        return buffer.getLong(LogEntryDescriptor.sourceEventPositionOffset(offset), Protocol.ENDIANNESS);
    }

    public static void setSourceEventPosition(MutableDirectBuffer buffer, int offset, long sourceEventPosition) {
        buffer.putLong(LogEntryDescriptor.sourceEventPositionOffset(offset), sourceEventPosition, Protocol.ENDIANNESS);
    }

    public static int keyOffset(int offset) {
        return KEY_OFFSET + offset;
    }

    public static long getKey(DirectBuffer buffer, int offset) {
        return buffer.getLong(LogEntryDescriptor.keyOffset(offset), Protocol.ENDIANNESS);
    }

    public static void setKey(MutableDirectBuffer buffer, int offset, long key) {
        buffer.putLong(LogEntryDescriptor.keyOffset(offset), key, Protocol.ENDIANNESS);
    }

    public static int flagsOffset(int offset) {
        return FLAGS_OFFSET + offset;
    }

    public static boolean shouldSkipProcessing(DirectBuffer buffer, int offset) {
        return buffer.getByte(LogEntryDescriptor.flagsOffset(offset)) != 0;
    }

    public static void skipProcessing(MutableDirectBuffer buffer, int offset) {
        buffer.putByte(LogEntryDescriptor.flagsOffset(offset), (byte)1);
    }

    public static int timestampOffset(int offset) {
        return TIMESTAMP_OFFSET + offset;
    }

    public static long getTimestamp(DirectBuffer buffer, int offset) {
        return buffer.getLong(LogEntryDescriptor.timestampOffset(offset), Protocol.ENDIANNESS);
    }

    public static void setTimestamp(MutableDirectBuffer buffer, int offset, long timestamp) {
        buffer.putLong(LogEntryDescriptor.timestampOffset(offset), timestamp, Protocol.ENDIANNESS);
    }

    public static int metadataLengthOffset(int offset) {
        return METADATA_LENGTH_OFFSET + offset;
    }

    public static int getMetadataLength(DirectBuffer buffer, int offset) {
        if (LogEntryDescriptor.getVersion(buffer, offset) == 1) {
            return buffer.getInt(LogEntryDescriptor.metadataLengthOffset(offset), Protocol.ENDIANNESS);
        }
        return buffer.getShort(LogEntryDescriptor.metadataLengthOffset(offset), Protocol.ENDIANNESS);
    }

    public static void setMetadataLength(MutableDirectBuffer buffer, int offset, int metadataLength) {
        buffer.putInt(LogEntryDescriptor.metadataLengthOffset(offset), metadataLength, Protocol.ENDIANNESS);
    }

    public static int metadataOffset(int offset) {
        return METADATA_OFFSET + offset;
    }

    public static int valueOffset(int offset, int metadataLength) {
        return METADATA_OFFSET + metadataLength + offset;
    }

    static {
        int offset;
        VERSION_OFFSET = offset = 0;
        offset += 2;
        FLAGS_OFFSET = offset++;
        POSITION_OFFSET = ++offset;
        SOURCE_EVENT_POSITION_OFFSET = offset += 8;
        KEY_OFFSET = offset += 8;
        TIMESTAMP_OFFSET = offset += 8;
        METADATA_LENGTH_OFFSET = offset += 8;
        HEADER_BLOCK_LENGTH = offset += 4;
        METADATA_OFFSET = offset;
    }
}

