/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import com.netflix.concurrency.limits.Limit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateLimit;
import io.camunda.zeebe.logstreams.impl.log.LogStreamImpl;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import java.time.InstantSource;
import java.util.Objects;

public final class LogStreamBuilderImpl
implements LogStreamBuilder {
    private static final int MINIMUM_FRAGMENT_SIZE = 4096;
    private int maxFragmentSize = 0x400000;
    private int partitionId = -1;
    private ActorSchedulingService actorSchedulingService;
    private LogStorage logStorage;
    private String logName;
    private InstantSource clock;
    private Limit requestLimit;
    private RateLimit writeRateLimit;

    @Override
    public LogStreamBuilder withActorSchedulingService(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
        return this;
    }

    @Override
    public LogStreamBuilder withMaxFragmentSize(int maxFragmentSize) {
        this.maxFragmentSize = maxFragmentSize;
        return this;
    }

    @Override
    public LogStreamBuilder withLogStorage(LogStorage logStorage) {
        this.logStorage = logStorage;
        return this;
    }

    @Override
    public LogStreamBuilder withPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @Override
    public LogStreamBuilder withLogName(String logName) {
        this.logName = logName;
        return this;
    }

    @Override
    public LogStreamBuilder withClock(InstantSource clock) {
        this.clock = clock;
        return this;
    }

    @Override
    public LogStreamBuilder withRequestLimit(Limit requestLimit) {
        this.requestLimit = requestLimit;
        return this;
    }

    @Override
    public LogStreamBuilder withWriteRateLimit(RateLimit writeRateLimit) {
        this.writeRateLimit = writeRateLimit;
        return this;
    }

    @Override
    public LogStream build() {
        this.validate();
        return new LogStreamImpl(this.logName, this.partitionId, this.maxFragmentSize, this.logStorage, this.clock, this.requestLimit, this.writeRateLimit);
    }

    private void validate() {
        Objects.requireNonNull(this.actorSchedulingService, "Must specify a actor scheduler");
        Objects.requireNonNull(this.logStorage, "Must specify a log storage");
        Objects.requireNonNull(this.clock, "Must specify a clock source");
        if (this.maxFragmentSize < 4096) {
            throw new IllegalArgumentException(String.format("Expected fragment size to be at least '%d', but was '%d'", 4096, this.maxFragmentSize));
        }
    }
}

