/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import java.util.Optional;
import java.util.Set;

public final class RequestLimiter
extends AbstractLimiter<Intent> {
    private static final Set<? extends Intent> WHITE_LISTED_COMMANDS = Set.of(JobIntent.COMPLETE, JobIntent.FAIL, ProcessInstanceIntent.CANCEL, DeploymentIntent.CREATE, DeploymentIntent.DISTRIBUTE, DeploymentDistributionIntent.COMPLETE, CommandDistributionIntent.ACKNOWLEDGE);
    private final LogStreamMetrics metrics;

    private RequestLimiter(CommandRateLimiterBuilder builder, LogStreamMetrics metrics) {
        super((AbstractLimiter.Builder)builder);
        this.metrics = metrics;
        metrics.setInflightRequests(0);
        metrics.setRequestLimit(this.getLimit());
    }

    public Optional<Limiter.Listener> acquire(Intent intent) {
        if (this.getInflight() >= this.getLimit() && !WHITE_LISTED_COMMANDS.contains(intent)) {
            return this.createRejectedListener();
        }
        Limiter.Listener listener = this.createListener();
        return Optional.of(listener);
    }

    protected void onNewLimit(int newLimit) {
        super.onNewLimit(newLimit);
        this.metrics.setRequestLimit(newLimit);
    }

    public static CommandRateLimiterBuilder builder() {
        return new CommandRateLimiterBuilder();
    }

    public static class CommandRateLimiterBuilder
    extends AbstractLimiter.Builder<CommandRateLimiterBuilder> {
        protected CommandRateLimiterBuilder self() {
            return this;
        }

        public RequestLimiter build(LogStreamMetrics metrics) {
            return new RequestLimiter(this, metrics);
        }
    }
}

