/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.serializer;

import io.camunda.zeebe.logstreams.impl.log.LogEntryDescriptor;
import io.camunda.zeebe.logstreams.impl.serializer.DataFrameDescriptor;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;

final class LogAppendEntrySerializer {
    LogAppendEntrySerializer() {
    }

    static int serialize(MutableDirectBuffer writeBuffer, int writeBufferOffset, LogAppendEntry entry, long position, long sourcePosition, long entryTimestamp) {
        Objects.requireNonNull(writeBuffer, "must specify a destination buffer");
        Objects.requireNonNull(entry, "must specify an entry");
        long key = entry.key();
        RecordMetadata metadata = entry.recordMetadata();
        UnifiedRecordValue value = entry.recordValue();
        Objects.requireNonNull(metadata, "must specify metadata");
        Objects.requireNonNull(value, "must specify value");
        if (writeBufferOffset < 0) {
            throw new IllegalArgumentException("Expected to serialize entry at a positive offset, but the offset given was %d".formatted(writeBufferOffset));
        }
        if (value.getLength() == 0) {
            throw new IllegalArgumentException("Expected to serialize an entry with a value, but the entry's value reports a length of 0");
        }
        if (metadata.getLength() == 0) {
            throw new IllegalArgumentException("Expected to serialize an entry with metadata, but the entry's metadata reports a length of 0");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Expected to serialize an entry with a positive position, but the position given was %d".formatted(position));
        }
        if (entryTimestamp < 0L) {
            throw new IllegalArgumentException("Expected to serialize an entry with a positive timestamp, but the timestamp given was %d".formatted(entryTimestamp));
        }
        int metadataLength = metadata.getLength();
        int framedEntryLength = LogAppendEntrySerializer.framedLength(entry);
        DataFrameDescriptor.setFramedLength(writeBuffer, writeBufferOffset, framedEntryLength);
        int entryOffset = writeBufferOffset + 12;
        LogEntryDescriptor.setVersion(writeBuffer, entryOffset);
        if (entry.isProcessed()) {
            LogEntryDescriptor.skipProcessing(writeBuffer, entryOffset);
        }
        LogEntryDescriptor.setPosition(writeBuffer, entryOffset, position);
        LogEntryDescriptor.setSourceEventPosition(writeBuffer, entryOffset, sourcePosition);
        LogEntryDescriptor.setKey(writeBuffer, entryOffset, key);
        LogEntryDescriptor.setTimestamp(writeBuffer, entryOffset, entryTimestamp);
        LogEntryDescriptor.setMetadataLength(writeBuffer, entryOffset, metadataLength);
        metadata.write(writeBuffer, LogEntryDescriptor.metadataOffset(entryOffset));
        value.write(writeBuffer, LogEntryDescriptor.valueOffset(entryOffset, metadataLength));
        return framedEntryLength;
    }

    static int framedLength(LogAppendEntry entry) {
        return DataFrameDescriptor.framedLength(LogEntryDescriptor.headerLength(entry.recordMetadata().getLength()) + entry.recordValue().getLength());
    }
}

