/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.log;

import io.camunda.zeebe.logstreams.impl.log.LogAppendEntryImpl;
import io.camunda.zeebe.logstreams.impl.log.ProcessedLogAppendEntryImpl;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import java.util.Objects;

public interface LogAppendEntry {
    public long key();

    public int sourceIndex();

    public RecordMetadata recordMetadata();

    public UnifiedRecordValue recordValue();

    default public int getLength() {
        return 12 + this.recordMetadata().getLength() + this.recordValue().getLength();
    }

    default public boolean isProcessed() {
        return false;
    }

    public static LogAppendEntry of(RecordMetadata recordMetadata, UnifiedRecordValue recordValue) {
        return new LogAppendEntryImpl(-1L, -1, Objects.requireNonNull(recordMetadata, "must specify metadata"), Objects.requireNonNull(recordValue, "must specify value"));
    }

    public static LogAppendEntry of(long key, RecordMetadata recordMetadata, UnifiedRecordValue recordValue) {
        return new LogAppendEntryImpl(key, -1, Objects.requireNonNull(recordMetadata, "must specify metadata"), Objects.requireNonNull(recordValue, "must specify value"));
    }

    public static LogAppendEntry ofProcessed(LogAppendEntry entry) {
        return new ProcessedLogAppendEntryImpl(entry);
    }
}

