/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.log;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.WriteContext;
import io.camunda.zeebe.util.Either;
import java.util.Collections;
import java.util.List;

@FunctionalInterface
public interface LogStreamWriter {
    default public boolean canWriteEvents(int eventCount, int batchSize) {
        return true;
    }

    default public Either<WriteFailure, Long> tryWrite(WriteContext context, LogAppendEntry appendEntry) {
        return this.tryWrite(context, appendEntry, -1L);
    }

    default public Either<WriteFailure, Long> tryWrite(WriteContext context, LogAppendEntry appendEntry, long sourcePosition) {
        return this.tryWrite(context, Collections.singletonList(appendEntry), sourcePosition);
    }

    default public Either<WriteFailure, Long> tryWrite(WriteContext context, List<LogAppendEntry> appendEntries) {
        return this.tryWrite(context, appendEntries, -1L);
    }

    public Either<WriteFailure, Long> tryWrite(WriteContext var1, List<LogAppendEntry> var2, long var3);

    public static enum WriteFailure {
        CLOSED,
        WRITE_LIMIT_EXHAUSTED,
        REQUEST_LIMIT_EXHAUSTED,
        INVALID_ARGUMENT;

    }
}

