/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.spec;

import io.camunda.zeebe.msgpack.spec.MsgPackCodes;
import io.camunda.zeebe.msgpack.spec.MsgPackFormat;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.spec.MsgPackToken;
import io.camunda.zeebe.msgpack.spec.MsgPackType;
import io.camunda.zeebe.msgpack.spec.MsgpackException;
import io.camunda.zeebe.msgpack.spec.MsgpackReaderException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MsgPackReader {
    private final MsgPackToken token = new MsgPackToken();
    private final DirectBuffer buffer = new UnsafeBuffer(0L, 0);
    private int offset;

    public MsgPackReader wrap(DirectBuffer buffer, int offset, int length) {
        this.buffer.wrap(buffer, offset, length);
        this.offset = 0;
        return this;
    }

    public void reset() {
        this.offset = 0;
    }

    public int readMapHeader() {
        int mapSize;
        byte headerByte = this.buffer.getByte(this.offset);
        ++this.offset;
        if (MsgPackCodes.isFixedMap(headerByte)) {
            mapSize = headerByte & 0xF;
        } else {
            switch (headerByte) {
                case -34: {
                    mapSize = this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER) & 0xFFFF;
                    this.offset += 2;
                    break;
                }
                case -33: {
                    mapSize = (int)this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER));
                    this.offset += 4;
                    break;
                }
                default: {
                    throw this.exceptionOnUnknownHeader("map", headerByte);
                }
            }
        }
        return mapSize;
    }

    public int readArrayHeader() {
        int mapSize;
        byte headerByte = this.buffer.getByte(this.offset);
        ++this.offset;
        if (MsgPackCodes.isFixedArray(headerByte)) {
            mapSize = headerByte & 0xF;
        } else {
            switch (headerByte) {
                case -36: {
                    mapSize = this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER) & 0xFFFF;
                    this.offset += 2;
                    break;
                }
                case -35: {
                    mapSize = (int)this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER));
                    this.offset += 4;
                    break;
                }
                default: {
                    throw this.exceptionOnUnknownHeader("array", headerByte);
                }
            }
        }
        return mapSize;
    }

    public int readStringLength() {
        int stringLength;
        byte headerByte = this.buffer.getByte(this.offset);
        ++this.offset;
        if (MsgPackCodes.isFixStr(headerByte)) {
            stringLength = headerByte & 0x1F;
        } else {
            switch (headerByte) {
                case -39: {
                    stringLength = this.buffer.getByte(this.offset) & 0xFF;
                    ++this.offset;
                    break;
                }
                case -38: {
                    stringLength = this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER) & 0xFFFF;
                    this.offset += 2;
                    break;
                }
                case -37: {
                    stringLength = (int)this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER));
                    this.offset += 4;
                    break;
                }
                default: {
                    throw this.exceptionOnUnknownHeader("string", headerByte);
                }
            }
        }
        return stringLength;
    }

    public int readBinaryLength() {
        int length;
        byte headerByte = this.buffer.getByte(this.offset);
        ++this.offset;
        switch (headerByte) {
            case -60: {
                length = this.buffer.getByte(this.offset) & 0xFF;
                ++this.offset;
                break;
            }
            case -59: {
                length = this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER) & 0xFFFF;
                this.offset += 2;
                break;
            }
            case -58: {
                length = (int)this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER));
                this.offset += 4;
                break;
            }
            default: {
                throw this.exceptionOnUnknownHeader("binary", headerByte);
            }
        }
        return length;
    }

    public long readInteger() {
        long val;
        byte headerByte = this.buffer.getByte(this.offset);
        ++this.offset;
        if (MsgPackCodes.isFixInt(headerByte)) {
            val = headerByte;
        } else {
            switch (headerByte) {
                case -52: {
                    val = (long)this.buffer.getByte(this.offset) & 0xFFL;
                    ++this.offset;
                    break;
                }
                case -51: {
                    val = (long)this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER) & 0xFFFFL;
                    this.offset += 2;
                    break;
                }
                case -50: {
                    val = (long)this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER) & 0xFFFFFFFFL;
                    this.offset += 4;
                    break;
                }
                case -49: {
                    val = this.ensurePositive(this.buffer.getLong(this.offset, MsgPackCodes.BYTE_ORDER));
                    this.offset += 8;
                    break;
                }
                case -48: {
                    val = this.buffer.getByte(this.offset);
                    ++this.offset;
                    break;
                }
                case -47: {
                    val = this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER);
                    this.offset += 2;
                    break;
                }
                case -46: {
                    val = this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER);
                    this.offset += 4;
                    break;
                }
                case -45: {
                    val = this.buffer.getLong(this.offset, MsgPackCodes.BYTE_ORDER);
                    this.offset += 8;
                    break;
                }
                default: {
                    throw this.exceptionOnUnknownHeader("long", headerByte);
                }
            }
        }
        return val;
    }

    public strictfp double readFloat() {
        double value;
        byte headerByte = this.buffer.getByte(this.offset);
        ++this.offset;
        switch (headerByte) {
            case -54: {
                value = this.buffer.getFloat(this.offset, MsgPackCodes.BYTE_ORDER);
                this.offset += 4;
                break;
            }
            case -53: {
                value = this.buffer.getDouble(this.offset, MsgPackCodes.BYTE_ORDER);
                this.offset += 8;
                break;
            }
            default: {
                throw this.exceptionOnUnknownHeader("float", headerByte);
            }
        }
        return value;
    }

    public boolean readBoolean() {
        boolean theBool;
        byte headerByte = this.buffer.getByte(this.offset);
        ++this.offset;
        switch (headerByte) {
            case -61: {
                theBool = true;
                break;
            }
            case -62: {
                theBool = false;
                break;
            }
            default: {
                throw this.exceptionOnUnknownHeader("boolean", headerByte);
            }
        }
        return theBool;
    }

    public MsgPackToken readToken() {
        byte b = this.buffer.getByte(this.offset);
        MsgPackFormat format = MsgPackFormat.valueOf(b);
        int currentOffset = this.offset;
        switch (format.type) {
            case INTEGER: {
                this.token.setType(MsgPackType.INTEGER);
                this.token.setValue(this.readInteger());
                break;
            }
            case FLOAT: {
                this.token.setType(MsgPackType.FLOAT);
                this.token.setValue(this.readFloat());
                break;
            }
            case BOOLEAN: {
                this.token.setType(MsgPackType.BOOLEAN);
                this.token.setValue(this.readBoolean());
                break;
            }
            case MAP: {
                this.token.setType(MsgPackType.MAP);
                this.token.setMapHeader(this.readMapHeader());
                break;
            }
            case ARRAY: {
                this.token.setType(MsgPackType.ARRAY);
                this.token.setArrayHeader(this.readArrayHeader());
                break;
            }
            case NIL: {
                this.token.setType(MsgPackType.NIL);
                this.skipValue();
                break;
            }
            case BINARY: {
                this.token.setType(MsgPackType.BINARY);
                int binaryLength = this.readBinaryLength();
                this.token.setValue(this.buffer, this.offset, binaryLength);
                this.skipBytes(binaryLength);
                break;
            }
            case STRING: {
                this.token.setType(MsgPackType.STRING);
                int stringLength = this.readStringLength();
                this.token.setValue(this.buffer, this.offset, stringLength);
                this.skipBytes(stringLength);
                break;
            }
            default: {
                throw new MsgpackReaderException(String.format("Unknown token format '%s'", format.getType().name()));
            }
        }
        this.token.setTotalLength(this.offset - currentOffset);
        return this.token;
    }

    public DirectBuffer getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public void skipValue() {
        this.skipValues(1L);
    }

    public void skipValues(long count) {
        while (count > 0L) {
            byte b = this.buffer.getByte(this.offset);
            ++this.offset;
            MsgPackFormat f = MsgPackFormat.valueOf(b);
            switch (f) {
                case POSFIXINT: 
                case NEGFIXINT: 
                case BOOLEAN: 
                case NIL: {
                    break;
                }
                case FIXMAP: {
                    int mapLen = b & 0xF;
                    count += (long)mapLen * 2L;
                    break;
                }
                case FIXARRAY: {
                    int arrayLen = b & 0xF;
                    count += (long)arrayLen;
                    break;
                }
                case FIXSTR: {
                    int strLen = b & 0x1F;
                    this.offset += strLen;
                    break;
                }
                case INT8: 
                case UINT8: {
                    ++this.offset;
                    break;
                }
                case INT16: 
                case UINT16: {
                    this.offset += 2;
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    this.offset += 4;
                    break;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    this.offset += 8;
                    break;
                }
                case BIN8: 
                case STR8: {
                    this.offset += 1 + Byte.toUnsignedInt(this.buffer.getByte(this.offset));
                    break;
                }
                case BIN16: 
                case STR16: {
                    this.offset += 2 + Short.toUnsignedInt(this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER));
                    break;
                }
                case BIN32: 
                case STR32: {
                    this.offset += 4 + (int)this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER));
                    break;
                }
                case FIXEXT1: {
                    this.offset += 2;
                    break;
                }
                case FIXEXT2: {
                    this.offset += 3;
                    break;
                }
                case FIXEXT4: {
                    this.offset += 5;
                    break;
                }
                case FIXEXT8: {
                    this.offset += 9;
                    break;
                }
                case FIXEXT16: {
                    this.offset += 17;
                    break;
                }
                case EXT8: {
                    this.offset += 2 + Byte.toUnsignedInt(this.buffer.getByte(this.offset));
                    break;
                }
                case EXT16: {
                    this.offset += 3 + Short.toUnsignedInt(this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER));
                    break;
                }
                case EXT32: {
                    this.offset += 5 + (int)this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER));
                    break;
                }
                case ARRAY16: {
                    count += (long)Short.toUnsignedInt(this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER));
                    this.offset += 2;
                    break;
                }
                case ARRAY32: {
                    count += this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER));
                    this.offset += 4;
                    break;
                }
                case MAP16: {
                    count += (long)Short.toUnsignedInt(this.buffer.getShort(this.offset, MsgPackCodes.BYTE_ORDER)) * 2L;
                    this.offset += 2;
                    break;
                }
                case MAP32: {
                    count += this.ensurePositive(this.buffer.getInt(this.offset, MsgPackCodes.BYTE_ORDER)) * 2L;
                    this.offset += 4;
                    break;
                }
                default: {
                    throw new MsgpackReaderException("Encountered 0xC1 \"NEVER_USED\" byte");
                }
            }
            --count;
        }
    }

    public void skipBytes(int stringLength) {
        this.offset += stringLength;
    }

    public boolean hasNext() {
        return this.offset < this.buffer.capacity();
    }

    private MsgpackReaderException exceptionOnUnknownHeader(String name, byte headerByte) {
        return new MsgpackReaderException(String.format("Unable to determine %s type, found unknown header byte 0x%02x at reader offset %d", name, headerByte, this.offset - 1));
    }

    private long ensurePositive(long size) {
        try {
            return MsgPackHelper.ensurePositive(size);
        }
        catch (MsgpackException e) {
            throw new MsgpackReaderException(e);
        }
    }
}

