/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporterConfiguration;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public record GetIndexStateManagementPolicyResponse(Policy policy, @JsonProperty(value="_seq_no") Integer seqNo, @JsonProperty(value="_primary_term") Integer primaryTerm) {
    @JsonIgnore
    public boolean equalsConfiguration(OpensearchExporterConfiguration configuration) {
        boolean hasEqualName = this.policy.policyId.equals(configuration.retention.getPolicyName());
        boolean hasEqualDescription = this.policy.description.equals(configuration.retention.getPolicyDescription());
        return hasEqualName && hasEqualDescription && this.hasEqualMinimumAge(configuration) && this.hasEqualIndexPrefix(configuration);
    }

    private boolean hasEqualMinimumAge(OpensearchExporterConfiguration configuration) {
        Optional<Policy.State> initialState = this.policy.states.stream().filter(state -> state.name.equals("initial")).findFirst();
        if (initialState.isEmpty()) {
            return false;
        }
        Optional<Policy.State.Transition> deleteTransition = initialState.get().transitions.stream().filter(transition -> transition.stateName.equals("delete")).findFirst();
        return deleteTransition.filter(transition -> transition.conditions.minIndexAge.equals(configuration.retention.getMinimumAge())).isPresent();
    }

    private boolean hasEqualIndexPrefix(OpensearchExporterConfiguration configuration) {
        Optional ismTemplate = this.policy.ismTemplate.stream().findFirst();
        if (ismTemplate.isEmpty()) {
            return false;
        }
        Optional indexPattern = ((Policy.IsmTemplate)ismTemplate.get()).indexPatterns.stream().findFirst();
        return indexPattern.map(s -> s.equals(configuration.index.prefix + "*")).orElse(false);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Policy(@JsonProperty(value="policy_id") String policyId, String description, @JsonProperty(value="default_state") String defaultState, List<State> states, @JsonProperty(value="ism_template") List<IsmTemplate> ismTemplate) {

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record IsmTemplate(@JsonProperty(value="index_patterns") List<String> indexPatterns, Integer priority) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record State(String name, List<Action> actions, List<Transition> transitions) {

            @JsonIgnoreProperties(ignoreUnknown=true)
            public record Transition(@JsonProperty(value="state_name") String stateName, Conditions conditions) {

                @JsonIgnoreProperties(ignoreUnknown=true)
                public record Conditions(@JsonProperty(value="min_index_age") String minIndexAge) {
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public record Action(Object delete) {
            }
        }
    }
}

