/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;

public class VariablesMapAssert
extends AbstractAssert<VariablesMapAssert, Map<String, String>> {
    static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ZeebeObjectMapper OBJECT_MAPPER = new ZeebeObjectMapper();

    public VariablesMapAssert(Map<String, String> actual) {
        super(actual, VariablesMapAssert.class);
    }

    public VariablesMapAssert containsVariable(String name) {
        ((MapAssert)Assertions.assertThat((Map)((Map)this.actual)).withFailMessage("Unable to find variable with name `%s`. Available variables are: %s", new Object[]{name, ((Map)this.actual).keySet()})).containsKey((Object)name);
        return this;
    }

    public VariablesMapAssert hasVariableWithValue(String name, Object value) {
        this.containsVariable(name);
        String expectedValue = OBJECT_MAPPER.toJson(value);
        String actualValue = (String)((Map)this.actual).get(name);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)VariablesMapAssert.isEqual(actualValue, expectedValue)).withFailMessage("The variable '%s' does not have the expected value. The value passed in ('%s') is internally mapped to a JSON String that yields '%s'. However, the actual value (as JSON String) is '%s'.", new Object[]{name, value, expectedValue, actualValue})).isTrue();
        return this;
    }

    private static boolean isEqual(String actualJson, String expectedJson) {
        return VariablesMapAssert.asJsonNode(actualJson).equals((Object)VariablesMapAssert.asJsonNode(expectedJson));
    }

    private static JsonNode asJsonNode(String json) {
        try {
            return JSON_MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JSON_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }
}

