/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class ProcessAssert
extends AbstractAssert<ProcessAssert, Process> {
    private final RecordStream recordStream;

    public ProcessAssert(Process actual, RecordStream recordStream) {
        super((Object)actual, ProcessAssert.class);
        this.recordStream = recordStream;
    }

    public ProcessAssert hasBpmnProcessId(String expectedBpmnProcessId) {
        Assertions.assertThat((String)expectedBpmnProcessId).isNotEmpty();
        String actualBpmnProcessId = ((Process)this.actual).getBpmnProcessId();
        ((AbstractStringAssert)Assertions.assertThat((String)actualBpmnProcessId).withFailMessage("Expected BPMN process ID to be '%s' but was '%s' instead.", new Object[]{expectedBpmnProcessId, actualBpmnProcessId})).isEqualTo(expectedBpmnProcessId);
        return this;
    }

    public ProcessAssert hasVersion(long expectedVersion) {
        long actualVersion = ((Process)this.actual).getVersion();
        ((AbstractLongAssert)Assertions.assertThat((long)actualVersion).withFailMessage("Expected version to be %d but was %d instead", new Object[]{expectedVersion, actualVersion})).isEqualTo(expectedVersion);
        return this;
    }

    public ProcessAssert hasResourceName(String expectedResourceName) {
        Assertions.assertThat((String)expectedResourceName).isNotEmpty();
        String actualResourceName = ((Process)this.actual).getResourceName();
        ((AbstractStringAssert)Assertions.assertThat((String)actualResourceName).withFailMessage("Expected resource name to be '%s' but was '%s' instead.", new Object[]{expectedResourceName, actualResourceName})).isEqualTo(expectedResourceName);
        return this;
    }

    public ProcessAssert hasAnyInstances() {
        boolean logContainsRecordsForThisProcess = this.getRecords().findFirst().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)logContainsRecordsForThisProcess).withFailMessage("The process has no instances", new Object[0])).isTrue();
        return this;
    }

    public ProcessAssert hasNoInstances() {
        boolean logContainsRecordsForThisProcess = this.getRecords().findFirst().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)logContainsRecordsForThisProcess).withFailMessage("The process does have instances", new Object[0])).isFalse();
        return this;
    }

    public ProcessAssert hasInstances(long expectedNumberOfInstances) {
        long actualNumberOfInstances = this.getRecordsByProcessInstanceId().size();
        ((AbstractLongAssert)Assertions.assertThat((long)actualNumberOfInstances).withFailMessage("Expected number of instances to be %d but was %d instead", new Object[]{expectedNumberOfInstances, actualNumberOfInstances})).isEqualTo(expectedNumberOfInstances);
        return this;
    }

    private Stream<Record<ProcessInstanceRecordValue>> getRecords() {
        return StreamFilter.processInstance((RecordStream)this.recordStream).withRejectionType(RejectionType.NULL_VAL).withElementId(((Process)this.actual).getBpmnProcessId()).withBpmnElementType(BpmnElementType.PROCESS).stream();
    }

    private Map<Long, List<Record<ProcessInstanceRecordValue>>> getRecordsByProcessInstanceId() {
        return this.getRecords().collect(Collectors.groupingBy(record -> ((ProcessInstanceRecordValue)record.getValue()).getProcessInstanceKey()));
    }
}

