/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.zeebe.process.test.assertions.IncidentAssert;
import io.camunda.zeebe.process.test.assertions.VariablesMapAssert;
import io.camunda.zeebe.process.test.filters.IncidentRecordStreamFilter;
import io.camunda.zeebe.process.test.filters.ProcessInstanceRecordStreamFilter;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;

public class ProcessInstanceAssert
extends AbstractAssert<ProcessInstanceAssert, Long> {
    private final RecordStream recordStream;

    public ProcessInstanceAssert(long actual, RecordStream recordStream) {
        super((Object)actual, ProcessInstanceAssert.class);
        this.recordStream = recordStream;
    }

    public ProcessInstanceAssert isStarted() {
        boolean isStarted = StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withIntent(ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnElementType(BpmnElementType.PROCESS).stream().findFirst().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)isStarted).withFailMessage("Process with key %s was not started", new Object[]{this.actual})).isTrue();
        return this;
    }

    public ProcessInstanceAssert isActive() {
        boolean isActive = StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withBpmnElementType(BpmnElementType.PROCESS).stream().noneMatch(record -> record.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED || record.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)isActive).withFailMessage("Process with key %s is not active", new Object[]{this.actual})).isTrue();
        return this;
    }

    public ProcessInstanceAssert isCompleted() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isProcessInstanceCompleted()).withFailMessage("Process with key %s was not completed", new Object[]{this.actual})).isTrue();
        return this;
    }

    public ProcessInstanceAssert isNotCompleted() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isProcessInstanceCompleted()).withFailMessage("Process with key %s was completed", new Object[]{this.actual})).isFalse();
        return this;
    }

    private boolean isProcessInstanceCompleted() {
        return StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withBpmnElementType(BpmnElementType.PROCESS).withIntent(ProcessInstanceIntent.ELEMENT_COMPLETED).stream().findFirst().isPresent();
    }

    public ProcessInstanceAssert isTerminated() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isProcessInstanceTerminated()).withFailMessage("Process with key %s was not terminated", new Object[]{this.actual})).isTrue();
        return this;
    }

    public ProcessInstanceAssert isNotTerminated() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isProcessInstanceTerminated()).withFailMessage("Process with key %s was terminated", new Object[]{this.actual})).isFalse();
        return this;
    }

    private boolean isProcessInstanceTerminated() {
        return StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withBpmnElementType(BpmnElementType.PROCESS).withIntent(ProcessInstanceIntent.ELEMENT_TERMINATED).stream().findFirst().isPresent();
    }

    public ProcessInstanceAssert hasPassedElement(String elementId) {
        return this.hasPassedElement(elementId, 1);
    }

    public ProcessInstanceAssert hasNotPassedElement(String elementId) {
        return this.hasPassedElement(elementId, 0);
    }

    public ProcessInstanceAssert hasPassedElement(String elementId, int times) {
        long count = StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withElementId(elementId).withIntents(new ProcessInstanceIntent[]{ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}).stream().count();
        ((AbstractLongAssert)Assertions.assertThat((long)count).withFailMessage("Expected element with id %s to be passed %s times, but was %s", new Object[]{elementId, times, count})).isEqualTo((long)times);
        return this;
    }

    public ProcessInstanceAssert hasPassedElementsInOrder(String ... elementIds) {
        List foundElementRecords = StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withElementIdIn(elementIds).withIntents(new ProcessInstanceIntent[]{ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}).stream().map(Record::getValue).map(ProcessInstanceRecordValue::getElementId).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(foundElementRecords).describedAs("Ordered elements", new Object[0])).isEqualTo(Arrays.asList(elementIds));
        return this;
    }

    public ProcessInstanceAssert isWaitingAtElements(String ... elementIds) {
        Set<String> elementsInWaitState = this.getElementsInWaitState();
        Assertions.assertThat(elementsInWaitState).containsAll(Arrays.asList(elementIds));
        return this;
    }

    public ProcessInstanceAssert isNotWaitingAtElements(String ... elementIds) {
        Set<String> elementsInWaitState = this.getElementsInWaitState();
        Assertions.assertThat(elementsInWaitState).doesNotContainAnyElementsOf(Arrays.asList(elementIds));
        return this;
    }

    private Set<String> getElementsInWaitState() {
        HashSet<String> elementsInWaitState = new HashSet<String>();
        StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withoutBpmnElementType(BpmnElementType.PROCESS).stream().collect(Collectors.toMap(record -> String.format("%s-%s", ((ProcessInstanceRecordValue)record.getValue()).getElementId(), ((ProcessInstanceRecordValue)record.getValue()).getFlowScopeKey()), record -> record, (existing, replacement) -> replacement)).forEach((key, record) -> {
            if (record.getIntent().equals(ProcessInstanceIntent.ELEMENT_ACTIVATED)) {
                elementsInWaitState.add(((ProcessInstanceRecordValue)record.getValue()).getElementId());
            }
        });
        return elementsInWaitState;
    }

    public ProcessInstanceAssert isWaitingExactlyAtElements(String ... elementIdsVarArg) {
        List<String> elementIds = Arrays.asList(elementIdsVarArg);
        Set<String> elementsInWaitState = this.getElementsInWaitState();
        ArrayList wrongfullyWaitingElementIds = new ArrayList();
        ArrayList wrongfullyNotWaitingElementIds = new ArrayList();
        StreamFilter.processInstance((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withoutBpmnElementType(BpmnElementType.PROCESS).withIntent(ProcessInstanceIntent.ELEMENT_ACTIVATED).stream().map(Record::getValue).map(ProcessInstanceRecordValue::getElementId).distinct().forEach(id -> {
            boolean shouldBeWaitingAtElement = elementIds.contains(id);
            boolean isWaitingAtElement = elementsInWaitState.contains(id);
            if (shouldBeWaitingAtElement && !isWaitingAtElement) {
                wrongfullyNotWaitingElementIds.add(id);
            } else if (!shouldBeWaitingAtElement && isWaitingAtElement) {
                wrongfullyWaitingElementIds.add(id);
            }
        });
        SoftAssertions softly = new SoftAssertions();
        ((BooleanAssert)softly.assertThat(wrongfullyWaitingElementIds.isEmpty()).withFailMessage("Process with key %s is waiting at element(s) with id(s) %s", new Object[]{this.actual, String.join((CharSequence)", ", wrongfullyWaitingElementIds)})).isTrue();
        ((BooleanAssert)softly.assertThat(wrongfullyNotWaitingElementIds.isEmpty()).withFailMessage("Process with key %s is not waiting at element(s) with id(s) %s", new Object[]{this.actual, String.join((CharSequence)", ", wrongfullyNotWaitingElementIds)})).isTrue();
        softly.assertAll();
        return this;
    }

    public ProcessInstanceAssert isWaitingForMessages(String ... messageNames) {
        Set<String> openMessageSubscriptions = this.getOpenMessageSubscriptions();
        Assertions.assertThat(openMessageSubscriptions).containsAll(Arrays.asList(messageNames));
        return this;
    }

    public ProcessInstanceAssert isNotWaitingForMessages(String ... messageNames) {
        Set<String> openMessageSubscriptions = this.getOpenMessageSubscriptions();
        Assertions.assertThat(openMessageSubscriptions).doesNotContainAnyElementsOf(Arrays.asList(messageNames));
        return this;
    }

    private Set<String> getOpenMessageSubscriptions() {
        HashSet<String> openMessageSubscriptions = new HashSet<String>();
        StreamFilter.processMessageSubscription((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).stream().collect(Collectors.toMap(record -> ((ProcessMessageSubscriptionRecordValue)record.getValue()).getElementInstanceKey(), record -> record, (existing, replacement) -> replacement)).forEach((key, record) -> {
            if (record.getIntent().equals(ProcessMessageSubscriptionIntent.CREATING) || record.getIntent().equals(ProcessMessageSubscriptionIntent.CREATED)) {
                openMessageSubscriptions.add(((ProcessMessageSubscriptionRecordValue)record.getValue()).getMessageName());
            }
        });
        return openMessageSubscriptions;
    }

    public ProcessInstanceAssert hasCorrelatedMessageByName(String messageName, int times) {
        ((AbstractStringAssert)Assertions.assertThat((String)messageName).describedAs("Message name", new Object[0])).isNotEmpty();
        ((AbstractIntegerAssert)Assertions.assertThat((int)times).describedAs("Times", new Object[0])).isGreaterThanOrEqualTo(0);
        long actualTimes = StreamFilter.processMessageSubscription((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withMessageName(messageName).withIntent(ProcessMessageSubscriptionIntent.CORRELATED).stream().count();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTimes).withFailMessage("Expected message with name '%s' to be correlated %d times, but was %d times", new Object[]{messageName, times, actualTimes})).isEqualTo((long)times);
        return this;
    }

    public ProcessInstanceAssert hasCorrelatedMessageByCorrelationKey(String correlationKey, int times) {
        ((AbstractStringAssert)Assertions.assertThat((String)correlationKey).describedAs("Correlation key", new Object[0])).isNotEmpty();
        ((AbstractIntegerAssert)Assertions.assertThat((int)times).describedAs("Times", new Object[0])).isGreaterThanOrEqualTo(0);
        long actualTimes = StreamFilter.processMessageSubscription((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).withCorrelationKey(correlationKey).withIntent(ProcessMessageSubscriptionIntent.CORRELATED).stream().count();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTimes).withFailMessage("Expected message with correlation key '%s' to be correlated %d times, but was %d times", new Object[]{correlationKey, times, actualTimes})).isEqualTo((long)times);
        return this;
    }

    public ProcessInstanceAssert hasVariable(String name) {
        this.getVariableAssert().containsVariable(name);
        return this;
    }

    public ProcessInstanceAssert hasVariableWithValue(String name, Object value) {
        this.getVariableAssert().hasVariableWithValue(name, value);
        return this;
    }

    private Map<String, String> getProcessInstanceVariables() {
        return ((Stream)StreamFilter.variable((RecordStream)this.recordStream).withProcessInstanceKey(((Long)this.actual).longValue()).withRejectionType(RejectionType.NULL_VAL).stream().sequential()).map(Record::getValue).collect(Collectors.toMap(VariableRecordValue::getName, VariableRecordValue::getValue, (value1, value2) -> value2));
    }

    private VariablesMapAssert getVariableAssert() {
        return new VariablesMapAssert(this.getProcessInstanceVariables());
    }

    public ProcessInstanceAssert hasAnyIncidents() {
        boolean incidentsWereRaised = this.getIncidentCreatedRecords().stream().findFirst().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)incidentsWereRaised).withFailMessage("No incidents were raised for this process instance", new Object[0])).isTrue();
        return this;
    }

    public ProcessInstanceAssert hasNoIncidents() {
        boolean incidentsWereRaised = this.getIncidentCreatedRecords().stream().findFirst().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)incidentsWereRaised).withFailMessage("Incidents were raised for this process instance", new Object[0])).isFalse();
        return this;
    }

    public IncidentAssert extractingLatestIncident() {
        this.hasAnyIncidents();
        List incidentCreatedRecords = this.getIncidentCreatedRecords().stream().collect(Collectors.toList());
        Record latestIncidentRecord = (Record)incidentCreatedRecords.get(incidentCreatedRecords.size() - 1);
        return new IncidentAssert(latestIncidentRecord.getKey(), this.recordStream);
    }

    private IncidentRecordStreamFilter getIncidentCreatedRecords() {
        return StreamFilter.incident((RecordStream)this.recordStream).withRejectionType(RejectionType.NULL_VAL).withIntent(IncidentIntent.CREATED).withProcessInstanceKey(((Long)this.actual).longValue());
    }

    public ProcessInstanceAssert extractingLatestCalledProcess(String processId) {
        this.hasCalledProcess(processId);
        Record latestCalledProcessRecord = (Record)this.getCalledProcessRecords().stream().reduce((first, second) -> second).orElseThrow(NoSuchElementException::new);
        return new ProcessInstanceAssert(latestCalledProcessRecord.getKey(), this.recordStream);
    }

    public ProcessInstanceAssert hasCalledProcess(String processId) {
        boolean hasCalledProcess = this.getCalledProcessRecords().stream().findAny().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasCalledProcess).withFailMessage("No process with id `%s` was called from this process", new Object[]{processId})).isTrue();
        return this;
    }

    private ProcessInstanceRecordStreamFilter getCalledProcessRecords() {
        return StreamFilter.processInstance((RecordStream)this.recordStream).withParentProcessInstanceKey(((Long)this.actual).longValue());
    }
}

