/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dispatcher;

import io.camunda.zeebe.dispatcher.AtomicPosition;
import io.camunda.zeebe.dispatcher.impl.PositionUtil;
import io.camunda.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.camunda.zeebe.scheduler.ActorCondition;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class BlockPeek
implements Iterable<DirectBuffer> {
    protected int streamId;
    protected int blockLength;
    protected final DataFrameIterator iterator = new DataFrameIterator();
    private ByteBuffer byteBuffer;
    private final UnsafeBuffer bufferView = new UnsafeBuffer(0L, 0);
    private AtomicPosition subscriberPosition;
    private int bufferOffset;
    private int newPartitionId;
    private int newPartitionOffset;
    private ActorCondition dataConsumed;

    public void setBlock(ByteBuffer byteBuffer, AtomicPosition position, ActorCondition dataConsumed, int streamId, int bufferOffset, int blockLength, int newPartitionId, int newPartitionOffset) {
        this.byteBuffer = byteBuffer;
        this.subscriberPosition = position;
        this.dataConsumed = dataConsumed;
        this.streamId = streamId;
        this.bufferOffset = bufferOffset;
        this.blockLength = blockLength;
        this.newPartitionId = newPartitionId;
        this.newPartitionOffset = newPartitionOffset;
        byteBuffer.limit(bufferOffset + blockLength);
        byteBuffer.position(bufferOffset);
        this.bufferView.wrap(byteBuffer, bufferOffset, blockLength);
    }

    public ByteBuffer getRawBuffer() {
        return this.byteBuffer;
    }

    public MutableDirectBuffer getBuffer() {
        return this.bufferView;
    }

    public void markFailed() {
        int frameLength;
        for (int fragmentOffset = 0; fragmentOffset < this.blockLength; fragmentOffset += frameLength) {
            int framedFragmentLength = this.bufferView.getInt(DataFrameDescriptor.lengthOffset(fragmentOffset));
            if (framedFragmentLength < 0) {
                framedFragmentLength = -framedFragmentLength;
            }
            frameLength = DataFrameDescriptor.alignedLength(framedFragmentLength);
            int flagsOffset = DataFrameDescriptor.flagsOffset(fragmentOffset);
            byte flags = this.bufferView.getByte(flagsOffset);
            this.bufferView.putByte(flagsOffset, DataFrameDescriptor.enableFlagFailed(flags));
        }
        this.updatePosition();
    }

    public void markCompleted() {
        this.updatePosition();
    }

    private void updatePosition() {
        this.subscriberPosition.proposeMaxOrdered(PositionUtil.position(this.newPartitionId, this.newPartitionOffset));
        this.dataConsumed.signal();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getBufferOffset() {
        return this.bufferOffset;
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    @Override
    public Iterator<DirectBuffer> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    protected class DataFrameIterator
    implements Iterator<DirectBuffer> {
        protected int iterationOffset;
        protected final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);

        protected DataFrameIterator() {
        }

        public void reset() {
            this.iterationOffset = 0;
        }

        @Override
        public boolean hasNext() {
            return this.iterationOffset < BlockPeek.this.blockLength;
        }

        @Override
        public DirectBuffer next() {
            int framedFragmentLength = BlockPeek.this.bufferView.getInt(DataFrameDescriptor.lengthOffset(this.iterationOffset));
            int fragmentLength = DataFrameDescriptor.messageLength(framedFragmentLength);
            int messageOffset = DataFrameDescriptor.messageOffset(this.iterationOffset);
            this.buffer.wrap(BlockPeek.this.bufferView, messageOffset, fragmentLength);
            this.iterationOffset += DataFrameDescriptor.alignedLength(framedFragmentLength);
            return this.buffer;
        }
    }
}

