/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dispatcher.impl.log;

import org.agrona.BitUtil;

public final class DataFrameDescriptor {
    public static final int FRAME_ALIGNMENT = 8;
    public static final int FRAME_LENGTH_OFFSET;
    public static final int VERSION_OFFSET;
    public static final int FLAGS_OFFSET;
    public static final int TYPE_OFFSET;
    public static final int STREAM_ID_OFFSET;
    public static final short TYPE_MESSAGE = 0;
    public static final short TYPE_PADDING = 1;
    public static final int HEADER_LENGTH;
    public static final int FLAG_BATCH_BEGIN_BITMASK = 128;
    public static final int FLAG_BATCH_END_BITMASK = 64;
    public static final int FLAG_FAILED_BITMASK = 32;

    public static int lengthOffset(int offset) {
        return offset + FRAME_LENGTH_OFFSET;
    }

    public static int versionOffset(int offset) {
        return offset + VERSION_OFFSET;
    }

    public static int flagsOffset(int offset) {
        return offset + FLAGS_OFFSET;
    }

    public static int typeOffset(int offset) {
        return offset + TYPE_OFFSET;
    }

    public static int streamIdOffset(int offset) {
        return offset + STREAM_ID_OFFSET;
    }

    public static int messageOffset(int offset) {
        return offset + HEADER_LENGTH;
    }

    public static int alignedFramedLength(int msgLength) {
        return DataFrameDescriptor.alignedLength(DataFrameDescriptor.framedLength(msgLength));
    }

    public static int alignedLength(int msgLength) {
        return BitUtil.align(msgLength, 8);
    }

    public static int framedLength(int msgLength) {
        return msgLength + HEADER_LENGTH;
    }

    public static int messageLength(int framedLength) {
        return framedLength - HEADER_LENGTH;
    }

    public static boolean flagFailed(byte flags) {
        return (flags & 0x20) != 0;
    }

    public static byte enableFlagFailed(byte flags) {
        return (byte)(flags | 0x20);
    }

    public static boolean flagBatchBegin(byte flags) {
        return (flags & 0x80) != 0;
    }

    public static byte enableFlagBatchBegin(byte flags) {
        return (byte)(flags | 0x80);
    }

    public static boolean flagBatchEnd(byte flags) {
        return (flags & 0x40) != 0;
    }

    public static byte enableFlagBatchEnd(byte flags) {
        return (byte)(flags | 0x40);
    }

    static {
        int offset;
        FRAME_LENGTH_OFFSET = offset = 0;
        offset += 4;
        VERSION_OFFSET = offset++;
        FLAGS_OFFSET = offset++;
        TYPE_OFFSET = offset + 2 - 2;
        STREAM_ID_OFFSET = offset += 2;
        HEADER_LENGTH = offset += 4;
    }
}

