/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.el.impl;

import io.camunda.zeebe.el.EvaluationContext;
import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.impl.EvaluationFailure;
import io.camunda.zeebe.el.impl.FeelExpression;
import io.camunda.zeebe.el.impl.InvalidExpression;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.el.impl.ZeebeFeelEngineClock;
import io.camunda.zeebe.el.impl.feel.FeelEvaluationResult;
import io.camunda.zeebe.el.impl.feel.FeelVariableContext;
import io.camunda.zeebe.feel.impl.FeelFunctionProvider;
import io.camunda.zeebe.feel.impl.FeelToMessagePackTransformer;
import io.camunda.zeebe.feel.impl.MessagePackValueMapper;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.syntaxtree.ParsedExpression;
import org.camunda.feel.syntaxtree.Val;
import scala.util.Either;

public final class FeelExpressionLanguage
implements ExpressionLanguage {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\=(.+)", 32);
    private final FeelToMessagePackTransformer messagePackTransformer = new FeelToMessagePackTransformer();
    private final FeelEngine feelEngine;

    public FeelExpressionLanguage(ActorClock clock) {
        this.feelEngine = new FeelEngine.Builder().customValueMapper(new MessagePackValueMapper()).functionProvider(new FeelFunctionProvider()).clock(new ZeebeFeelEngineClock(clock)).build();
    }

    @Override
    public Expression parseExpression(String expression) {
        EnsureUtil.ensureNotNull("expression", expression);
        Matcher expressionMatcher = EXPRESSION_PATTERN.matcher(expression);
        if (expressionMatcher.matches()) {
            String unpackedExpression = expressionMatcher.group(1);
            return this.parseFeelExpression(unpackedExpression);
        }
        return new StaticExpression(expression);
    }

    @Override
    public EvaluationResult evaluateExpression(Expression expression, EvaluationContext context) {
        EnsureUtil.ensureNotNull("expression", expression);
        EnsureUtil.ensureNotNull("context", context);
        if (!expression.isValid()) {
            String failureMessage = expression.getFailureMessage();
            return new EvaluationFailure(expression, failureMessage);
        }
        if (expression instanceof StaticExpression) {
            StaticExpression staticExpression = (StaticExpression)expression;
            return staticExpression;
        }
        if (expression instanceof FeelExpression) {
            FeelExpression feelExpression = (FeelExpression)expression;
            return this.evaluateFeelExpression(expression, context, feelExpression);
        }
        throw new IllegalArgumentException(String.format("Expected FEEL expression or static value but found '%s'", expression));
    }

    private Expression parseFeelExpression(String expression) {
        Either<FeelEngine.Failure, ParsedExpression> parseResult = this.feelEngine.parseExpression(expression);
        if (parseResult.isLeft()) {
            FeelEngine.Failure failure = parseResult.left().get();
            return new InvalidExpression(expression, failure.message());
        }
        ParsedExpression parsedExpression = parseResult.right().get();
        return new FeelExpression(parsedExpression);
    }

    private EvaluationResult evaluateFeelExpression(Expression expression, EvaluationContext context, FeelExpression feelExpression) {
        FeelVariableContext feelContext;
        ParsedExpression parsedExpression = feelExpression.getParsedExpression();
        Either<FeelEngine.Failure, Object> evalResult = this.feelEngine.eval(parsedExpression, feelContext = new FeelVariableContext(context));
        if (evalResult.isLeft()) {
            FeelEngine.Failure failure = evalResult.left().get();
            return new EvaluationFailure(expression, failure.message());
        }
        Object result = evalResult.right().get();
        if (result instanceof Val) {
            return new FeelEvaluationResult(expression, (Val)result, this.messagePackTransformer::toMessagePack);
        }
        throw new IllegalStateException(String.format("Expected FEEL evaluation result to be of type '%s' but was '%s'", Val.class, result.getClass()));
    }
}

