/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.api.ProcessingResultBuilder;
import io.camunda.zeebe.engine.api.RecordProcessor;
import io.camunda.zeebe.engine.api.RecordProcessorContext;
import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.api.records.RecordBatch;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContextImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.ProcessingDbState;
import io.camunda.zeebe.engine.state.processing.DbBannedInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class Engine
implements RecordProcessor {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private static final String ERROR_MESSAGE_PROCESSOR_NOT_FOUND = "Expected to find processor for record '{}', but caught an exception. Skip this record.";
    private static final String ERROR_MESSAGE_PROCESSING_EXCEPTION_OCCURRED = "Expected to process record '%s' without errors, but exception occurred with message '%s'.";
    private static final EnumSet<ValueType> SUPPORTED_VALUETYPES = EnumSet.range(ValueType.JOB, ValueType.PROCESS_INSTANCE_BATCH);
    private EventApplier eventApplier;
    private RecordProcessorMap recordProcessorMap;
    private ProcessingDbState processingState;
    private final ErrorRecord errorRecord = new ErrorRecord();
    private final ProcessingResultBuilderMutex resultBuilderMutex = new ProcessingResultBuilderMutex();
    private Writers writers;
    private final TypedRecordProcessorFactory typedRecordProcessorFactory;
    private final EngineConfiguration config;

    public Engine(TypedRecordProcessorFactory typedRecordProcessorFactory, EngineConfiguration config) {
        this.typedRecordProcessorFactory = typedRecordProcessorFactory;
        this.config = config;
    }

    @Override
    public void init(RecordProcessorContext recordProcessorContext) {
        ZeebeDb zeebeDb = recordProcessorContext.getZeebeDb();
        this.processingState = new ProcessingDbState(recordProcessorContext.getPartitionId(), zeebeDb, recordProcessorContext.getTransactionContext(), recordProcessorContext.getKeyGenerator(), this.config);
        this.eventApplier = recordProcessorContext.getEventApplierFactory().apply(this.processingState);
        this.writers = new Writers(this.resultBuilderMutex, this.eventApplier);
        TypedRecordProcessorContextImpl typedProcessorContext = new TypedRecordProcessorContextImpl(recordProcessorContext.getPartitionId(), recordProcessorContext.getScheduleService(), this.processingState, zeebeDb, this.writers, recordProcessorContext.getPartitionCommandSender(), this.config);
        TypedRecordProcessors typedRecordProcessors = this.typedRecordProcessorFactory.createProcessors(typedProcessorContext);
        recordProcessorContext.addLifecycleListeners(typedRecordProcessors.getLifecycleListeners());
        this.recordProcessorMap = typedRecordProcessors.getRecordProcessorMap();
    }

    @Override
    public boolean accepts(ValueType valueType) {
        return SUPPORTED_VALUETYPES.contains((Object)valueType);
    }

    @Override
    public void replay(TypedRecord event) {
        this.eventApplier.applyState(event.getKey(), event.getIntent(), event.getValue());
    }

    @Override
    public ProcessingResult process(TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            boolean noBanCheckNeeded;
            TypedRecordProcessor currentProcessor = null;
            TypedRecord typedCommand = record;
            try {
                currentProcessor = this.recordProcessorMap.get(typedCommand.getRecordType(), typedCommand.getValueType(), typedCommand.getIntent().value());
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_PROCESSOR_NOT_FOUND, (Object)typedCommand, (Object)e);
            }
            if (currentProcessor == null) {
                ProcessingResult e = processingResultBuilder.build();
                return e;
            }
            boolean bl = noBanCheckNeeded = !(record.getIntent() instanceof ProcessInstanceRelatedIntent) || record.getIntent() instanceof ProcessInstanceCreationIntent;
            if (noBanCheckNeeded || !this.processingState.getBannedInstanceState().isBanned(typedCommand)) {
                currentProcessor.processRecord(record);
            }
        }
        return processingResultBuilder.build();
    }

    @Override
    public ProcessingResult onProcessingError(Throwable processingException, TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            TypedRecordProcessor.ProcessingError error2;
            TypedRecord typedCommand = record;
            TypedRecordProcessor processor = null;
            try {
                processor = this.recordProcessorMap.get(typedCommand.getRecordType(), typedCommand.getValueType(), typedCommand.getIntent().value());
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_PROCESSOR_NOT_FOUND, (Object)typedCommand, (Object)e);
            }
            TypedRecordProcessor.ProcessingError processingError = error2 = processor == null ? TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR : processor.tryHandleError(record, processingException);
            if (error2 == TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR) {
                this.handleUnexpectedError(processingException, record);
            }
        }
        return processingResultBuilder.build();
    }

    private void handleUnexpectedError(Throwable processingException, TypedRecord record) {
        String errorMessage = String.format(ERROR_MESSAGE_PROCESSING_EXCEPTION_OCCURRED, record, processingException.getMessage());
        LOG.error(errorMessage, processingException);
        if (processingException instanceof RecordBatch.ExceededBatchRecordSizeException) {
            this.writers.rejection().appendRejection(record, RejectionType.EXCEEDED_BATCH_RECORD_SIZE, "");
            this.writers.response().writeRejectionOnCommand(record, RejectionType.EXCEEDED_BATCH_RECORD_SIZE, "");
        } else {
            this.writers.rejection().appendRejection(record, RejectionType.PROCESSING_ERROR, errorMessage);
            this.writers.response().writeRejectionOnCommand(record, RejectionType.PROCESSING_ERROR, errorMessage);
        }
        this.errorRecord.initErrorRecord(processingException, record.getPosition());
        if (DbBannedInstanceState.shouldBeBanned(record.getIntent())) {
            if (record.getValue() instanceof ProcessInstanceRelated) {
                long processInstanceKey = ((ProcessInstanceRelated)((Object)record.getValue())).getProcessInstanceKey();
                this.errorRecord.setProcessInstanceKey(processInstanceKey);
            }
            this.writers.state().appendFollowUpEvent(record.getKey(), ErrorIntent.CREATED, this.errorRecord);
        }
    }

    private static final class ProcessingResultBuilderMutex
    implements Supplier<ProcessingResultBuilder> {
        private ProcessingResultBuilder resultBuilder;

        private ProcessingResultBuilderMutex() {
        }

        private void setResultBuilder(ProcessingResultBuilder resultBuilder) {
            this.resultBuilder = Objects.requireNonNull(resultBuilder);
        }

        private void unsetResultBuilder() {
            this.resultBuilder = null;
        }

        @Override
        public ProcessingResultBuilder get() {
            if (this.resultBuilder == null) {
                throw new IllegalStateException("Attempt to retrieve resultBuilder out of scope.");
            }
            return this.resultBuilder;
        }
    }

    private final class ProcessingResultBuilderScope
    implements AutoCloseable {
        private ProcessingResultBuilderScope(ProcessingResultBuilder processingResultBuilder) {
            Engine.this.resultBuilderMutex.setResultBuilder(processingResultBuilder);
        }

        @Override
        public void close() {
            Engine.this.resultBuilderMutex.unsetResultBuilder();
        }
    }
}

