/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;

public final class BpmnEventSubscriptionBehavior {
    private final EventScopeInstanceState eventScopeInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final ProcessState processState;
    private final EventTriggerBehavior eventTriggerBehavior;

    public BpmnEventSubscriptionBehavior(CatchEventBehavior catchEventBehavior, EventTriggerBehavior eventTriggerBehavior, ProcessingState processingState) {
        this.catchEventBehavior = catchEventBehavior;
        this.eventTriggerBehavior = eventTriggerBehavior;
        this.processState = processingState.getProcessState();
        this.eventScopeInstanceState = processingState.getEventScopeInstanceState();
    }

    public <T extends ExecutableCatchEventSupplier> Either<Failure, Void> subscribeToEvents(T element, BpmnElementContext context) {
        return this.catchEventBehavior.subscribeToEvents(context, element);
    }

    public void unsubscribeFromEvents(BpmnElementContext context) {
        this.catchEventBehavior.unsubscribeFromEvents(context.getElementInstanceKey());
    }

    public Optional<EventTrigger> findEventTrigger(BpmnElementContext context) {
        long elementInstanceKey = context.getElementInstanceKey();
        return Optional.ofNullable(this.eventScopeInstanceState.peekEventTrigger(elementInstanceKey)).filter(trigger -> !BufferUtil.contentsEqual(trigger.getElementId(), context.getElementId()));
    }

    public void activateTriggeredEvent(long eventScopeKey, long flowScopeKey, EventTrigger eventTrigger, BpmnElementContext context) {
        ExecutableFlowElement triggeredEvent = this.processState.getFlowElement(context.getProcessDefinitionKey(), eventTrigger.getElementId(), ExecutableFlowElement.class);
        this.eventTriggerBehavior.activateTriggeredEvent(eventTrigger.getEventKey(), triggeredEvent, eventScopeKey, flowScopeKey, context.getRecordValue(), eventTrigger.getVariables());
    }

    public Optional<EventTrigger> getEventTriggerForProcessDefinition(long processDefinitionKey) {
        EventTrigger eventTrigger = this.eventScopeInstanceState.peekEventTrigger(processDefinitionKey);
        return Optional.ofNullable(eventTrigger);
    }

    public void activateTriggeredStartEvent(BpmnElementContext context, EventTrigger eventTrigger) {
        this.activateTriggeredEvent(context.getProcessDefinitionKey(), context.getProcessInstanceKey(), eventTrigger, context);
    }
}

