/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class CallActivityProcessor
implements BpmnElementContainerProcessor<ExecutableCallActivity> {
    private static final String UNABLE_TO_COMPLETE_FROM_STATE_MESSAGE = "Expected to complete call activity after child completed, but call activity cannot be completed from state '%s'";
    private static final String UNABLE_TO_TERMINATE_FROM_STATE_MESSAGE = "Expected to terminate call activity after child terminated, but call activity cannot be terminated from state '%s'";
    private final ExpressionProcessor expressionProcessor;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;

    public CallActivityProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
    }

    @Override
    public Class<ExecutableCallActivity> getType() {
        return ExecutableCallActivity.class;
    }

    @Override
    public void onActivate(ExecutableCallActivity element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).flatMap(ok -> this.evaluateProcessId(context, element)).flatMap(this::getProcessForProcessId).flatMap(this::checkProcessHasNoneStartEvent).ifRightOrLeft(process -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
            long childProcessInstanceKey = this.stateTransitionBehavior.createChildProcessInstance((DeployedProcess)process, context);
            long callActivityInstanceKey = activated.getElementInstanceKey();
            this.stateBehavior.copyVariablesToProcessInstance(callActivityInstanceKey, childProcessInstanceKey, (DeployedProcess)process);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onComplete(ExecutableCallActivity element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            return this.stateTransitionBehavior.transitionToCompleted(element, context);
        }).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableCallActivity element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.terminateChildProcessInstance(this, element, context);
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableCallActivity element, BpmnElementContext callActivityContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        ProcessInstanceIntent currentState = callActivityContext.getIntent();
        if (currentState == ProcessInstanceIntent.ELEMENT_ACTIVATED) {
            this.stateTransitionBehavior.completeElement(callActivityContext);
        } else if (currentState == ProcessInstanceIntent.ELEMENT_TERMINATING) {
            this.transitionToTerminated(element, callActivityContext);
        } else {
            String message = String.format(UNABLE_TO_COMPLETE_FROM_STATE_MESSAGE, currentState);
            throw new BpmnProcessingException(callActivityContext, message);
        }
    }

    @Override
    public void onChildTerminated(ExecutableCallActivity element, BpmnElementContext callActivityContext, BpmnElementContext childContext) {
        ProcessInstanceIntent currentState = callActivityContext.getIntent();
        if (currentState != ProcessInstanceIntent.ELEMENT_TERMINATING) {
            String message = String.format(UNABLE_TO_TERMINATE_FROM_STATE_MESSAGE, currentState);
            throw new BpmnProcessingException(callActivityContext, message);
        }
        this.transitionToTerminated(element, callActivityContext);
    }

    private void transitionToTerminated(ExecutableCallActivity element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)eventTrigger, terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }

    private Either<Failure, DirectBuffer> evaluateProcessId(BpmnElementContext context, ExecutableCallActivity element) {
        Expression processIdExpression = element.getCalledElementProcessId();
        long scopeKey = context.getElementInstanceKey();
        return this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(processIdExpression, scopeKey);
    }

    private Either<Failure, DeployedProcess> getProcessForProcessId(DirectBuffer processId) {
        Optional<DeployedProcess> process = this.stateBehavior.getLatestProcessVersion(processId);
        if (process.isPresent()) {
            return Either.right(process.get());
        }
        return Either.left(new Failure(String.format("Expected process with BPMN process id '%s' to be deployed, but not found.", BufferUtil.bufferAsString(processId)), ErrorType.CALLED_ELEMENT_ERROR));
    }

    private Either<Failure, DeployedProcess> checkProcessHasNoneStartEvent(DeployedProcess process) {
        if (process.getProcess().getNoneStartEvent() == null) {
            return Either.left(new Failure(String.format("Expected process with BPMN process id '%s' to have a none start event, but not found.", BufferUtil.bufferAsString(process.getBpmnProcessId())), ErrorType.CALLED_ELEMENT_ERROR));
        }
        return Either.right(process);
    }
}

