/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableIntermediateThrowEvent;

public class IntermediateThrowEventProcessor
implements BpmnElementProcessor<ExecutableIntermediateThrowEvent> {
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnJobBehavior jobBehavior;

    public IntermediateThrowEventProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableIntermediateThrowEvent> getType() {
        return ExecutableIntermediateThrowEvent.class;
    }

    @Override
    public void onActivate(ExecutableIntermediateThrowEvent element, BpmnElementContext context) {
        if (element.getJobWorkerProperties() != null) {
            this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.jobBehavior.createNewJob(context, element)).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
        } else {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
            this.stateTransitionBehavior.completeElement(activated);
        }
    }

    @Override
    public void onComplete(ExecutableIntermediateThrowEvent element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> this.stateTransitionBehavior.transitionToCompleted(element, context)).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableIntermediateThrowEvent element, BpmnElementContext context) {
        if (element.getJobWorkerProperties() != null) {
            this.jobBehavior.cancelJob(context);
        }
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
        this.incidentBehavior.resolveIncidents(terminated);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }
}

