/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public class MessageStartEventSubscriptionManager {
    private final MessageStartEventSubscriptionRecord subscriptionRecord = new MessageStartEventSubscriptionRecord();
    private final ProcessState processState;
    private final MessageStartEventSubscriptionState messageStartEventSubscriptionState;
    private final KeyGenerator keyGenerator;

    public MessageStartEventSubscriptionManager(ProcessState processState, MessageStartEventSubscriptionState messageStartEventSubscriptionState, KeyGenerator keyGenerator) {
        this.processState = processState;
        this.messageStartEventSubscriptionState = messageStartEventSubscriptionState;
        this.keyGenerator = keyGenerator;
    }

    public void tryReOpenMessageStartEventSubscription(DeploymentRecord deploymentRecord, StateWriter stateWriter) {
        for (ProcessMetadata processRecord : deploymentRecord.processesMetadata()) {
            if (!this.isLatestProcess(processRecord)) continue;
            this.closeExistingMessageStartEventSubscriptions(processRecord, stateWriter);
            this.openMessageStartEventSubscriptions(processRecord, stateWriter);
        }
    }

    private boolean isLatestProcess(ProcessMetadata processRecord) {
        return this.processState.getLatestProcessVersionByProcessId(processRecord.getBpmnProcessIdBuffer()).getVersion() == processRecord.getVersion();
    }

    private void closeExistingMessageStartEventSubscriptions(ProcessMetadata processRecord, StateWriter stateWriter) {
        DeployedProcess lastMsgProcess = this.findLastMessageStartProcess(processRecord);
        if (lastMsgProcess == null) {
            return;
        }
        this.messageStartEventSubscriptionState.visitSubscriptionsByProcessDefinition(lastMsgProcess.getKey(), subscription -> stateWriter.appendFollowUpEvent(subscription.getKey(), MessageStartEventSubscriptionIntent.DELETED, subscription.getRecord()));
    }

    private DeployedProcess findLastMessageStartProcess(ProcessMetadata processRecord) {
        for (int version = processRecord.getVersion() - 1; version > 0; --version) {
            DeployedProcess lastMsgProcess = this.processState.getProcessByProcessIdAndVersion(processRecord.getBpmnProcessIdBuffer(), version);
            if (lastMsgProcess == null || !lastMsgProcess.getProcess().getStartEvents().stream().anyMatch(ExecutableCatchEventElement::isMessage)) continue;
            return lastMsgProcess;
        }
        return null;
    }

    private void openMessageStartEventSubscriptions(ProcessMetadata processRecord, StateWriter stateWriter) {
        long processDefinitionKey = processRecord.getKey();
        DeployedProcess processDefinition = this.processState.getProcessByKey(processDefinitionKey);
        ExecutableProcess process = processDefinition.getProcess();
        List<ExecutableStartEvent> startEvents = process.getStartEvents();
        for (ExecutableCatchEventElement executableCatchEventElement : startEvents) {
            if (!executableCatchEventElement.isMessage()) continue;
            ExecutableMessage message = executableCatchEventElement.getMessage();
            message.getMessageName().map(BufferUtil::wrapString).ifPresent(messageNameBuffer -> {
                this.subscriptionRecord.reset();
                this.subscriptionRecord.setMessageName((DirectBuffer)messageNameBuffer).setProcessDefinitionKey(processDefinitionKey).setBpmnProcessId(process.getId()).setStartEventId(startEvent.getId());
                long subscriptionKey = this.keyGenerator.nextKey();
                stateWriter.appendFollowUpEvent(subscriptionKey, MessageStartEventSubscriptionIntent.CREATED, this.subscriptionRecord);
            });
        }
    }
}

