/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.distribute;

import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentDistributionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;

public final class DeploymentDistributionCommandSender {
    private final InterPartitionCommandSender sender;
    private final int partitionId;

    public DeploymentDistributionCommandSender(int partitionId, InterPartitionCommandSender sender) {
        this.partitionId = partitionId;
        this.sender = sender;
    }

    public void distributeToPartition(long key, int receiverPartitionId, DeploymentRecord deploymentRecord) {
        this.sender.sendCommand(receiverPartitionId, ValueType.DEPLOYMENT, DeploymentIntent.DISTRIBUTE, key, deploymentRecord);
    }

    public void completeOnPartition(long deploymentKey) {
        DeploymentDistributionRecord distributionRecord = new DeploymentDistributionRecord();
        distributionRecord.setPartition(this.partitionId);
        this.sender.sendCommand(1, ValueType.DEPLOYMENT_DISTRIBUTION, DeploymentDistributionIntent.COMPLETE, deploymentKey, distributionRecord);
    }
}

