/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.VariableMappingTransformer;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeIoMapping;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeMapping;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.Optional;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public final class FlowNodeTransformer
implements ModelElementTransformer<FlowNode> {
    private final VariableMappingTransformer variableMappingTransformer = new VariableMappingTransformer();

    @Override
    public Class<FlowNode> getType() {
        return FlowNode.class;
    }

    @Override
    public void transform(FlowNode flowNode, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableFlowNode element = process.getElementById(flowNode.getId(), ExecutableFlowNode.class);
        this.setParentReference(flowNode, process, element);
        this.transformIoMappings(flowNode, element, context.getExpressionLanguage());
    }

    private void setParentReference(FlowNode flowNode, ExecutableProcess process, ExecutableFlowNode element) {
        ModelElementInstance parentElement = flowNode.getParentElement();
        Optional.ofNullable(parentElement.getAttributeValue("id")).map(BufferUtil::wrapString).map(process::getElementById).ifPresent(element::setFlowScope);
    }

    private void transformIoMappings(FlowNode element, ExecutableFlowNode flowNode, ExpressionLanguage expressionLanguage) {
        Optional<ZeebeIoMapping> ioMapping = Optional.ofNullable(element.getSingleExtensionElement(ZeebeIoMapping.class));
        ioMapping.map(ZeebeIoMapping::getInputs).filter(mappings -> !mappings.isEmpty()).map(mappings -> this.variableMappingTransformer.transformInputMappings((Collection<? extends ZeebeMapping>)mappings, expressionLanguage)).ifPresent(flowNode::setInputMappings);
        ioMapping.map(ZeebeIoMapping::getOutputs).filter(mappings -> !mappings.isEmpty()).map(mappings -> this.variableMappingTransformer.transformOutputMappings((Collection<? extends ZeebeMapping>)mappings, expressionLanguage)).ifPresent(flowNode::setOutputMappings);
    }
}

